/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.exceptions.OnErrorThrowable;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;

public final class OnSubscribeMap<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<T> source;
    final Func1<? super T, ? extends R> transformer;

    public OnSubscribeMap(Observable<T> source2, Func1<? super T, ? extends R> transformer) {
        this.source = source2;
        this.transformer = transformer;
    }

    @Override
    public void call(Subscriber<? super R> o) {
        MapSubscriber<? super T, ? extends R> parent = new MapSubscriber<T, R>(o, this.transformer);
        o.add(parent);
        this.source.unsafeSubscribe(parent);
    }

    static final class MapSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Func1<? super T, ? extends R> mapper;
        boolean done;

        public MapSubscriber(Subscriber<? super R> actual, Func1<? super T, ? extends R> mapper) {
            this.actual = actual;
            this.mapper = mapper;
        }

        @Override
        public void onNext(T t) {
            R result;
            try {
                result = this.mapper.call(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }
            this.actual.onNext(result);
        }

        @Override
        public void onError(Throwable e2) {
            if (this.done) {
                RxJavaHooks.onError(e2);
                return;
            }
            this.done = true;
            this.actual.onError(e2);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            this.actual.setProducer(p);
        }
    }
}

