/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Observable;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Single;
import io.mantisrx.mql.shaded.rx.SingleSubscriber;
import io.mantisrx.mql.shaded.rx.Subscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.exceptions.Exceptions;
import io.mantisrx.mql.shaded.rx.functions.Func1;
import io.mantisrx.mql.shaded.rx.internal.operators.BackpressureUtils;
import io.mantisrx.mql.shaded.rx.internal.operators.NotificationLite;
import io.mantisrx.mql.shaded.rx.internal.util.ExceptionsUtils;
import io.mantisrx.mql.shaded.rx.internal.util.atomic.MpscLinkedAtomicQueue;
import io.mantisrx.mql.shaded.rx.internal.util.unsafe.MpscLinkedQueue;
import io.mantisrx.mql.shaded.rx.internal.util.unsafe.UnsafeAccess;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import io.mantisrx.mql.shaded.rx.subscriptions.CompositeSubscription;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class OnSubscribeFlatMapSingle<T, R>
implements Observable.OnSubscribe<R> {
    final Observable<T> source;
    final Func1<? super T, ? extends Single<? extends R>> mapper;
    final boolean delayErrors;
    final int maxConcurrency;

    public OnSubscribeFlatMapSingle(Observable<T> source2, Func1<? super T, ? extends Single<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
        if (mapper == null) {
            throw new NullPointerException("mapper is null");
        }
        if (maxConcurrency <= 0) {
            throw new IllegalArgumentException("maxConcurrency > 0 required but it was " + maxConcurrency);
        }
        this.source = source2;
        this.mapper = mapper;
        this.delayErrors = delayErrors;
        this.maxConcurrency = maxConcurrency;
    }

    @Override
    public void call(Subscriber<? super R> child) {
        FlatMapSingleSubscriber<? super T, ? super R> parent = new FlatMapSingleSubscriber<T, R>(child, this.mapper, this.delayErrors, this.maxConcurrency);
        child.add(parent.set);
        child.add(parent.requested);
        child.setProducer(parent.requested);
        this.source.unsafeSubscribe(parent);
    }

    static final class FlatMapSingleSubscriber<T, R>
    extends Subscriber<T> {
        final Subscriber<? super R> actual;
        final Func1<? super T, ? extends Single<? extends R>> mapper;
        final boolean delayErrors;
        final int maxConcurrency;
        final AtomicInteger wip;
        final AtomicInteger active;
        final CompositeSubscription set;
        final AtomicReference<Throwable> errors;
        final Queue<Object> queue;
        final Requested requested;
        volatile boolean done;
        volatile boolean cancelled;

        FlatMapSingleSubscriber(Subscriber<? super R> actual, Func1<? super T, ? extends Single<? extends R>> mapper, boolean delayErrors, int maxConcurrency) {
            this.actual = actual;
            this.mapper = mapper;
            this.delayErrors = delayErrors;
            this.maxConcurrency = maxConcurrency;
            this.wip = new AtomicInteger();
            this.errors = new AtomicReference();
            this.requested = new Requested();
            this.set = new CompositeSubscription();
            this.active = new AtomicInteger();
            this.queue = UnsafeAccess.isUnsafeAvailable() ? new MpscLinkedQueue<Object>() : new MpscLinkedAtomicQueue<Object>();
            this.request(maxConcurrency != Integer.MAX_VALUE ? (long)maxConcurrency : Long.MAX_VALUE);
        }

        @Override
        public void onNext(T t) {
            Single<R> c;
            try {
                c = this.mapper.call(t);
                if (c == null) {
                    throw new NullPointerException("The mapper returned a null Single");
                }
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(ex);
                return;
            }
            InnerSubscriber inner = new InnerSubscriber();
            this.set.add(inner);
            this.active.incrementAndGet();
            c.subscribe(inner);
        }

        @Override
        public void onError(Throwable e2) {
            if (this.delayErrors) {
                ExceptionsUtils.addThrowable(this.errors, e2);
            } else {
                this.set.unsubscribe();
                if (!this.errors.compareAndSet(null, e2)) {
                    RxJavaHooks.onError(e2);
                    return;
                }
            }
            this.done = true;
            this.drain();
        }

        @Override
        public void onCompleted() {
            this.done = true;
            this.drain();
        }

        void innerSuccess(InnerSubscriber inner, R value) {
            this.queue.offer(NotificationLite.next(value));
            this.set.remove(inner);
            this.active.decrementAndGet();
            this.drain();
        }

        void innerError(InnerSubscriber inner, Throwable e2) {
            if (this.delayErrors) {
                ExceptionsUtils.addThrowable(this.errors, e2);
                this.set.remove(inner);
                if (!this.done && this.maxConcurrency != Integer.MAX_VALUE) {
                    this.request(1L);
                }
            } else {
                this.set.unsubscribe();
                this.unsubscribe();
                if (!this.errors.compareAndSet(null, e2)) {
                    RxJavaHooks.onError(e2);
                    return;
                }
                this.done = true;
            }
            this.active.decrementAndGet();
            this.drain();
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber<R> a = this.actual;
            Queue<Object> q = this.queue;
            boolean delayError = this.delayErrors;
            AtomicInteger act = this.active;
            do {
                long e2;
                long r = this.requested.get();
                for (e2 = 0L; e2 != r; ++e2) {
                    boolean empty2;
                    Throwable ex;
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    boolean d = this.done;
                    if (!delayError && d && (ex = this.errors.get()) != null) {
                        q.clear();
                        a.onError(ExceptionsUtils.terminate(this.errors));
                        return;
                    }
                    Object o = q.poll();
                    boolean bl = empty2 = o == null;
                    if (d && act.get() == 0 && empty2) {
                        Throwable ex2 = this.errors.get();
                        if (ex2 != null) {
                            a.onError(ExceptionsUtils.terminate(this.errors));
                        } else {
                            a.onCompleted();
                        }
                        return;
                    }
                    if (empty2) break;
                    a.onNext(NotificationLite.getValue(o));
                }
                if (e2 == r) {
                    if (this.cancelled) {
                        q.clear();
                        return;
                    }
                    if (this.done) {
                        if (delayError) {
                            if (act.get() == 0 && q.isEmpty()) {
                                Throwable ex = this.errors.get();
                                if (ex != null) {
                                    a.onError(ExceptionsUtils.terminate(this.errors));
                                } else {
                                    a.onCompleted();
                                }
                                return;
                            }
                        } else {
                            Throwable ex = this.errors.get();
                            if (ex != null) {
                                q.clear();
                                a.onError(ExceptionsUtils.terminate(this.errors));
                                return;
                            }
                            if (act.get() == 0 && q.isEmpty()) {
                                a.onCompleted();
                                return;
                            }
                        }
                    }
                }
                if (e2 == 0L) continue;
                this.requested.produced(e2);
                if (this.done || this.maxConcurrency == Integer.MAX_VALUE) continue;
                this.request(e2);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }

        final class InnerSubscriber
        extends SingleSubscriber<R> {
            InnerSubscriber() {
            }

            @Override
            public void onSuccess(R t) {
                FlatMapSingleSubscriber.this.innerSuccess(this, t);
            }

            @Override
            public void onError(Throwable error) {
                FlatMapSingleSubscriber.this.innerError(this, error);
            }
        }

        final class Requested
        extends AtomicLong
        implements Producer,
        Subscription {
            private static final long serialVersionUID = -887187595446742742L;

            Requested() {
            }

            @Override
            public void request(long n) {
                if (n > 0L) {
                    BackpressureUtils.getAndAddRequest(this, n);
                    FlatMapSingleSubscriber.this.drain();
                }
            }

            void produced(long e2) {
                BackpressureUtils.produced(this, e2);
            }

            @Override
            public void unsubscribe() {
                FlatMapSingleSubscriber.this.cancelled = true;
                FlatMapSingleSubscriber.this.unsubscribe();
                if (FlatMapSingleSubscriber.this.wip.getAndIncrement() == 0) {
                    FlatMapSingleSubscriber.this.queue.clear();
                }
            }

            @Override
            public boolean isUnsubscribed() {
                return FlatMapSingleSubscriber.this.cancelled;
            }
        }
    }
}

