/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx.internal.operators;

import io.mantisrx.mql.shaded.rx.Completable;
import io.mantisrx.mql.shaded.rx.CompletableSubscriber;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.plugins.RxJavaHooks;
import io.mantisrx.mql.shaded.rx.subscriptions.CompositeSubscription;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public final class CompletableOnSubscribeMergeIterable
implements Completable.OnSubscribe {
    final Iterable<? extends Completable> sources;

    public CompletableOnSubscribeMergeIterable(Iterable<? extends Completable> sources) {
        this.sources = sources;
    }

    @Override
    public void call(final CompletableSubscriber s) {
        Iterator<? extends Completable> iterator;
        final CompositeSubscription set2 = new CompositeSubscription();
        s.onSubscribe(set2);
        try {
            iterator = this.sources.iterator();
        }
        catch (Throwable e2) {
            s.onError(e2);
            return;
        }
        if (iterator == null) {
            s.onError(new NullPointerException("The source iterator returned is null"));
            return;
        }
        final AtomicInteger wip = new AtomicInteger(1);
        final AtomicBoolean once = new AtomicBoolean();
        while (true) {
            Completable c;
            boolean b;
            if (set2.isUnsubscribed()) {
                return;
            }
            try {
                b = iterator.hasNext();
            }
            catch (Throwable e3) {
                set2.unsubscribe();
                if (once.compareAndSet(false, true)) {
                    s.onError(e3);
                } else {
                    RxJavaHooks.onError(e3);
                }
                return;
            }
            if (!b) break;
            if (set2.isUnsubscribed()) {
                return;
            }
            try {
                c = iterator.next();
            }
            catch (Throwable e4) {
                set2.unsubscribe();
                if (once.compareAndSet(false, true)) {
                    s.onError(e4);
                } else {
                    RxJavaHooks.onError(e4);
                }
                return;
            }
            if (set2.isUnsubscribed()) {
                return;
            }
            if (c == null) {
                set2.unsubscribe();
                NullPointerException npe = new NullPointerException("A completable source is null");
                if (once.compareAndSet(false, true)) {
                    s.onError(npe);
                } else {
                    RxJavaHooks.onError(npe);
                }
                return;
            }
            wip.getAndIncrement();
            c.unsafeSubscribe(new CompletableSubscriber(){

                @Override
                public void onSubscribe(Subscription d) {
                    set2.add(d);
                }

                @Override
                public void onError(Throwable e2) {
                    set2.unsubscribe();
                    if (once.compareAndSet(false, true)) {
                        s.onError(e2);
                    } else {
                        RxJavaHooks.onError(e2);
                    }
                }

                @Override
                public void onCompleted() {
                    if (wip.decrementAndGet() == 0 && once.compareAndSet(false, true)) {
                        s.onCompleted();
                    }
                }
            });
        }
        if (wip.decrementAndGet() == 0 && once.compareAndSet(false, true)) {
            s.onCompleted();
        }
    }
}

