/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.mql.shaded.rx;

import io.mantisrx.mql.shaded.rx.Observer;
import io.mantisrx.mql.shaded.rx.Producer;
import io.mantisrx.mql.shaded.rx.Subscription;
import io.mantisrx.mql.shaded.rx.internal.util.SubscriptionList;

public abstract class Subscriber<T>
implements Observer<T>,
Subscription {
    private static final long NOT_SET = Long.MIN_VALUE;
    private final SubscriptionList subscriptions;
    private final Subscriber<?> subscriber;
    private Producer producer;
    private long requested = Long.MIN_VALUE;

    protected Subscriber() {
        this(null, false);
    }

    protected Subscriber(Subscriber<?> subscriber2) {
        this(subscriber2, true);
    }

    protected Subscriber(Subscriber<?> subscriber2, boolean shareSubscriptions) {
        this.subscriber = subscriber2;
        this.subscriptions = shareSubscriptions && subscriber2 != null ? subscriber2.subscriptions : new SubscriptionList();
    }

    public final void add(Subscription s) {
        this.subscriptions.add(s);
    }

    @Override
    public final void unsubscribe() {
        this.subscriptions.unsubscribe();
    }

    @Override
    public final boolean isUnsubscribed() {
        return this.subscriptions.isUnsubscribed();
    }

    public void onStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void request(long n) {
        Producer producerToRequestFrom;
        if (n < 0L) {
            throw new IllegalArgumentException("number requested cannot be negative: " + n);
        }
        Subscriber subscriber2 = this;
        synchronized (subscriber2) {
            if (this.producer == null) {
                this.addToRequested(n);
                return;
            }
            producerToRequestFrom = this.producer;
        }
        producerToRequestFrom.request(n);
    }

    private void addToRequested(long n) {
        long total;
        this.requested = this.requested == Long.MIN_VALUE ? n : ((total = this.requested + n) < 0L ? Long.MAX_VALUE : total);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProducer(Producer p) {
        long toRequest;
        boolean passToSubscriber = false;
        Subscriber subscriber2 = this;
        synchronized (subscriber2) {
            toRequest = this.requested;
            this.producer = p;
            if (this.subscriber != null && toRequest == Long.MIN_VALUE) {
                passToSubscriber = true;
            }
        }
        if (passToSubscriber) {
            this.subscriber.setProducer(this.producer);
        } else if (toRequest == Long.MIN_VALUE) {
            this.producer.request(Long.MAX_VALUE);
        } else {
            this.producer.request(toRequest);
        }
    }
}

