/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.kafka.sink;

import io.mantisrx.sourcejob.kafka.sink.MQLQueryManager;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

final class QueryRefCountMap {
    private static Logger logger = Logger.getLogger(QueryRefCountMap.class);
    public static final QueryRefCountMap INSTANCE = new QueryRefCountMap();
    private final ConcurrentHashMap<String, AtomicInteger> refCntMap = new ConcurrentHashMap();

    private QueryRefCountMap() {
    }

    void addQuery(String subId, String query) {
        logger.info((Object)("adding query " + subId + " query " + query));
        if (this.refCntMap.containsKey(subId)) {
            int newVal = this.refCntMap.get(subId).incrementAndGet();
            logger.info((Object)("query exists already incrementing refcnt to " + newVal));
        } else {
            MQLQueryManager.getInstance().registerQuery(subId, query);
            this.refCntMap.putIfAbsent(subId, new AtomicInteger(1));
            logger.info((Object)"new query registering it");
        }
    }

    void removeQuery(String subId) {
        if (this.refCntMap.containsKey(subId)) {
            AtomicInteger refCnt = this.refCntMap.get(subId);
            int currVal = refCnt.decrementAndGet();
            if (currVal == 0) {
                MQLQueryManager.getInstance().deregisterQuery(subId);
                this.refCntMap.remove(subId);
                logger.info((Object)"All references to query are gone removing query");
            } else {
                logger.info((Object)("References to query still exist. decremeting refcnt to " + currVal));
            }
        } else {
            logger.warn((Object)("No query with subscriptionId " + subId));
        }
    }

    public int getUniqueSubscriptionsCount() {
        return this.refCntMap.size();
    }

    int getQueryRefCount(String subId) {
        if (this.refCntMap.containsKey(subId)) {
            return this.refCntMap.get(subId).get();
        }
        return 0;
    }
}

