/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.kafka.sink;

import io.mantisrx.runtime.Context;
import io.mantisrx.sourcejob.kafka.sink.QueryRefCountMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func2;

public class QueryRequestPreProcessor
implements Func2<Map<String, List<String>>, Context, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRequestPreProcessor.class);

    public Void call(Map<String, List<String>> queryParams, Context context) {
        LOGGER.info("QueryRequestPreProcessor:queryParams: {}", queryParams);
        if (queryParams != null && queryParams.containsKey("subscriptionId") && queryParams.containsKey("criterion")) {
            String subId = queryParams.get("subscriptionId").get(0);
            String query = queryParams.get("criterion").get(0);
            String clientId = queryParams.get("clientId").get(0);
            if (subId != null && query != null) {
                try {
                    LOGGER.info("Registering query {}", (Object)query);
                    if (clientId != null && !clientId.isEmpty()) {
                        QueryRequestPreProcessor.registerQuery(clientId + "_" + subId, query);
                    } else {
                        QueryRequestPreProcessor.registerQuery(subId, query);
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Error registering query", t);
                }
            }
        }
        return null;
    }

    private static synchronized void registerQuery(String subId, String query) {
        QueryRefCountMap.INSTANCE.addQuery(subId, query);
    }
}

