/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.kafka.sink;

import io.mantisrx.runtime.Context;
import io.mantisrx.sourcejob.kafka.sink.QueryRefCountMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import rx.functions.Func2;

public class QueryRequestPostProcessor
implements Func2<Map<String, List<String>>, Context, Void> {
    private static Logger logger = Logger.getLogger(QueryRequestPostProcessor.class);

    public Void call(Map<String, List<String>> queryParams, Context context) {
        logger.info((Object)("RequestPostProcessor:queryParams: " + queryParams));
        if (queryParams != null && queryParams.containsKey("subscriptionId") && queryParams.containsKey("criterion")) {
            String subId = queryParams.get("subscriptionId").get(0);
            String query = queryParams.get("criterion").get(0);
            String clientId = queryParams.get("clientId").get(0);
            if (subId != null && query != null) {
                try {
                    if (clientId != null && !clientId.isEmpty()) {
                        this.deregisterQuery(clientId + "_" + subId);
                    } else {
                        this.deregisterQuery(subId);
                    }
                }
                catch (Throwable t) {
                    logger.error((Object)"Error propagating unsubscription notification", t);
                }
            }
        }
        return null;
    }

    private void deregisterQuery(String subId) {
        QueryRefCountMap.INSTANCE.removeQuery(subId);
    }
}

