/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.kafka.sink;

import io.mantisrx.runtime.Context;
import io.mantisrx.runtime.PortRequest;
import io.mantisrx.runtime.sink.ServerSentEventsSink;
import io.mantisrx.runtime.sink.Sink;
import io.mantisrx.runtime.sink.predicate.Predicate;
import io.mantisrx.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.sourcejob.kafka.core.TaggedData;
import io.mantisrx.sourcejob.kafka.sink.TaggedEventFilter;
import java.util.List;
import java.util.Map;
import rx.Observable;
import rx.functions.Func1;
import rx.functions.Func2;

public class TaggedDataSourceSink
implements Sink<TaggedData> {
    private Func2<Map<String, List<String>>, Context, Void> preProcessor = new NoOpProcessor();
    private Func2<Map<String, List<String>>, Context, Void> postProcessor = new NoOpProcessor();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public TaggedDataSourceSink() {
    }

    public TaggedDataSourceSink(Func2<Map<String, List<String>>, Context, Void> preProcessor, Func2<Map<String, List<String>>, Context, Void> postProcessor) {
        this.postProcessor = postProcessor;
        this.preProcessor = preProcessor;
    }

    public void call(Context context, PortRequest portRequest, Observable<TaggedData> observable) {
        observable = observable.filter(t1 -> !t1.getPayload().isEmpty());
        ServerSentEventsSink sink = new ServerSentEventsSink.Builder().withEncoder(data -> {
            try {
                String json = OBJECT_MAPPER.writeValueAsString(data.getPayload());
                return json;
            }
            catch (JsonProcessingException e) {
                e.printStackTrace();
                return "{\"error\":" + e.getMessage() + "}";
            }
        }).withPredicate(new Predicate("description", (Func1)new TaggedEventFilter())).withRequestPreprocessor(this.preProcessor).withRequestPostprocessor(this.postProcessor).build();
        observable.subscribe();
        sink.call(context, portRequest, observable);
    }

    static class NoOpProcessor
    implements Func2<Map<String, List<String>>, Context, Void> {
        NoOpProcessor() {
        }

        public Void call(Map<String, List<String>> t1, Context t2) {
            return null;
        }
    }
}

