/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.kafka.sink;

import io.mantisrx.sourcejob.kafka.core.TaggedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import rx.functions.Func1;

public class TaggedEventFilter
implements Func1<Map<String, List<String>>, Func1<TaggedData, Boolean>> {
    private static Logger logger = Logger.getLogger(TaggedEventFilter.class);

    public Func1<TaggedData, Boolean> call(Map<String, List<String>> parameters) {
        Func1 filter = t1 -> true;
        if (parameters != null) {
            if (parameters.containsKey("subscriptionId")) {
                String subId = parameters.get("subscriptionId").get(0);
                String clientId = parameters.get("clientId").get(0);
                ArrayList<String> terms = new ArrayList<String>();
                if (clientId != null && !clientId.isEmpty()) {
                    terms.add(clientId + "_" + subId);
                } else {
                    terms.add(subId);
                }
                filter = new SourceEventFilter(terms);
            }
            return filter;
        }
        return filter;
    }

    private static class SourceEventFilter
    implements Func1<TaggedData, Boolean> {
        private String jobId = "UNKNOWN";
        private String jobName = "UNKNOWN";
        private List<String> terms;

        SourceEventFilter(List<String> terms) {
            String jName;
            this.terms = terms;
            String jId = System.getenv("JOB_ID");
            if (jId != null && !jId.isEmpty()) {
                this.jobId = jId;
            }
            if ((jName = System.getenv("JOB_NAME")) != null && !jName.isEmpty()) {
                this.jobName = jName;
            }
            logger.info((Object)("Created SourceEventFilter! for subId " + terms.toString() + " in Job : " + this.jobName + " with Id " + this.jobId));
        }

        public Boolean call(TaggedData data) {
            boolean match = true;
            for (String term : this.terms) {
                if (data.matchesClient(term)) continue;
                match = false;
                break;
            }
            return match;
        }
    }
}

