/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.kafka;

import io.mantisrx.connector.kafka.KafkaAckable;
import io.mantisrx.connector.kafka.source.serde.ParseException;
import io.mantisrx.connector.kafka.source.serde.Parser;
import io.mantisrx.connector.kafka.source.serde.ParserType;
import io.mantisrx.runtime.Context;
import io.mantisrx.sourcejob.kafka.AbstractAckableTaggingStage;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoAckTaggingStage
extends AbstractAckableTaggingStage {
    private static final Logger LOG = LoggerFactory.getLogger(AutoAckTaggingStage.class);
    private static final Logger logger = LoggerFactory.getLogger(AutoAckTaggingStage.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Object> processAndAck(Context context, KafkaAckable ackable) {
        block9: {
            String messageParserType;
            block8: {
                Boolean messageParsedInSource = (Boolean)context.getParameters().get("parseMessageInKafkaConsumerThread", (Object)true);
                messageParserType = (String)context.getParameters().get("messageParserType", (Object)ParserType.SIMPLE_JSON.getPropName());
                if (!messageParsedInSource.booleanValue()) break block8;
                Optional parsedEventO = ackable.getKafkaData().getParsedEvent();
                Map<String, Object> map = parsedEventO.orElse(Collections.emptyMap());
                ackable.ack();
                return map;
            }
            Parser parser = ParserType.parser((String)messageParserType).getParser();
            if (!parser.canParse(ackable.getKafkaData().getRawBytes())) break block9;
            Map map = parser.parseMessage(ackable.getKafkaData().getRawBytes());
            ackable.ack();
            return map;
        }
        try {
            try {
                LOG.warn("cannot parse message {}", (Object)ackable.getKafkaData().getRawBytes().toString());
                throw new ParseException("cannot parse message");
            }
            catch (Throwable t) {
                if (t instanceof ParseException) {
                    logger.warn("failed to parse message", t);
                } else {
                    logger.error("caught unexpected exception", t);
                }
                ackable.ack();
            }
        }
        catch (Throwable throwable) {
            ackable.ack();
            throw throwable;
        }
        return Collections.emptyMap();
    }

    @Override
    protected Map<String, Object> preProcess(Map<String, Object> rawData) {
        return rawData;
    }
}

