/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.sourcejob.kafka.core.utils;

import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectReader;
import io.mantisrx.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.util.Map;

public class JsonUtility {
    private static final JsonUtility INSTANCE = new JsonUtility();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectReader objectReader = this.objectMapper.readerFor(Map.class);
    private final ObjectWriter objectWriter = this.objectMapper.writerFor(Map.class);

    private JsonUtility() {
    }

    public static Map<String, Object> jsonToMap(String jsonString) {
        return INSTANCE._jsonToMap(jsonString);
    }

    public static String mapToJson(Map<String, ? extends Object> map) {
        return INSTANCE._mapToJson(map);
    }

    private Map<String, Object> _jsonToMap(String jsonString) {
        try {
            return (Map)this.objectReader.readValue(jsonString);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse JSON", e);
        }
    }

    private String _mapToJson(Map<String, ? extends Object> map) {
        try {
            return this.objectWriter.writeValueAsString(map);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write JSON", e);
        }
    }
}

