/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker;

import io.mantisrx.runtime.MantisJobState;
import io.mantisrx.server.core.Status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Heartbeat {
    private static final Logger logger = LoggerFactory.getLogger(Heartbeat.class);
    private final String jobId;
    private final int stageNumber;
    private final int workerIndex;
    private final int workerNumber;
    private final ConcurrentMap<String, String> payloads;
    private final BlockingQueue<PayloadPair> singleUsePayloads = new LinkedBlockingQueue<PayloadPair>();
    private final Optional<String> host;

    Heartbeat(String jobId, int stageNumber, int workerIndex, int workerNumber) {
        this(jobId, stageNumber, workerIndex, workerNumber, null);
    }

    Heartbeat(String jobId, int stageNumber, int workerIndex, int workerNumber, @Nullable String host) {
        this.jobId = jobId;
        this.stageNumber = stageNumber;
        this.workerIndex = workerIndex;
        this.workerNumber = workerNumber;
        this.host = Optional.ofNullable(host);
        this.payloads = new ConcurrentHashMap<String, String>();
    }

    void setPayload(String name, String value) {
        logger.info("Setting payload " + name);
        if (name != null && !name.isEmpty() && value != null) {
            this.payloads.put(name, value);
        }
    }

    boolean clearPayload(String name) {
        return this.payloads.remove(name) != null;
    }

    void addSingleUsePayload(String name, String value) {
        logger.debug("Adding payload {}={}", (Object)name, (Object)value);
        this.singleUsePayloads.offer(new PayloadPair(name, value));
    }

    Status getCurrentHeartbeatStatus() {
        ArrayList<Status.Payload> payloadList = new ArrayList<Status.Payload>();
        logger.debug("#Payloads = " + this.payloads.size());
        for (Map.Entry entry : this.payloads.entrySet()) {
            logger.debug("Adding payload " + (String)entry.getKey() + " with value " + (String)entry.getValue());
            payloadList.add(new Status.Payload((String)entry.getKey(), (String)entry.getValue()));
        }
        ArrayList singleUsePlds = new ArrayList();
        this.singleUsePayloads.drainTo(singleUsePlds);
        if (!singleUsePlds.isEmpty()) {
            HashMap<String, String> suplds = new HashMap<String, String>();
            for (PayloadPair payloadPair : singleUsePlds) {
                suplds.put(payloadPair.name, payloadPair.value);
            }
            for (Map.Entry entry : suplds.entrySet()) {
                payloadList.add(new Status.Payload((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        Status status = new Status(this.jobId, this.stageNumber, this.workerIndex, this.workerNumber, Status.TYPE.HEARTBEAT, "heartbeat", MantisJobState.Noop);
        this.host.ifPresent(arg_0 -> ((Status)status).setHostname(arg_0));
        if (!payloadList.isEmpty()) {
            status.setPayloads(payloadList);
        }
        return status;
    }

    private static class PayloadPair {
        String name;
        String value;

        public PayloadPair(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

