/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.worker.client;

import com.netflix.spectator.api.Tag;
import io.mantisrx.common.metrics.Gauge;
import io.mantisrx.common.metrics.Metrics;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import mantis.io.reactivex.netty.channel.ObservableConnection;
import mantis.io.reactivex.netty.client.ClientChannelFactory;
import mantis.io.reactivex.netty.client.ClientConnectionFactory;
import mantis.io.reactivex.netty.client.ClientMetricsEvent;
import mantis.io.reactivex.netty.client.ConnectionPoolBuilder;
import mantis.io.reactivex.netty.client.RxClient;
import mantis.io.reactivex.netty.metrics.MetricEventsSubject;
import mantis.io.reactivex.netty.pipeline.PipelineConfigurator;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientImpl;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientRequest;
import mantis.io.reactivex.netty.protocol.http.client.HttpClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class MantisHttpClientImpl<I, O>
extends HttpClientImpl<I, O> {
    private static final Logger log = LoggerFactory.getLogger(MantisHttpClientImpl.class);
    private Observable<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> observableConection;
    private List<Channel> connectionTracker = new ArrayList<Channel>();
    private final Gauge numConnectionsTracked;
    private static final String connectionTrackerMetricgroup = "ConnectionMonitor";
    private static final String metricName = "numConnectionsTracked";
    private static final String metricTagName = "uuid";

    public MantisHttpClientImpl(String name, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ClientChannelFactory<HttpClientResponse<O>, HttpClientRequest<I>> channelFactory, ClientConnectionFactory<HttpClientResponse<O>, HttpClientRequest<I>, ? extends ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connectionFactory, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name, serverInfo, clientBootstrap, pipelineConfigurator, clientConfig, channelFactory, connectionFactory, eventsSubject);
        Tag metricTag = Tag.of((String)metricTagName, (String)UUID.randomUUID().toString());
        Metrics m = new Metrics.Builder().id(connectionTrackerMetricgroup, new Tag[]{metricTag}).addGauge(metricName).build();
        this.numConnectionsTracked = m.getGauge(metricName);
    }

    public MantisHttpClientImpl(String name, RxClient.ServerInfo serverInfo, Bootstrap clientBootstrap, PipelineConfigurator<HttpClientResponse<O>, HttpClientRequest<I>> pipelineConfigurator, RxClient.ClientConfig clientConfig, ConnectionPoolBuilder<HttpClientResponse<O>, HttpClientRequest<I>> poolBuilder, MetricEventsSubject<ClientMetricsEvent<?>> eventsSubject) {
        super(name, serverInfo, clientBootstrap, pipelineConfigurator, clientConfig, poolBuilder, eventsSubject);
        Tag metricTag = Tag.of((String)metricTagName, (String)UUID.randomUUID().toString());
        Metrics m = new Metrics.Builder().id(connectionTrackerMetricgroup, new Tag[]{metricTag}).addGauge(metricName).build();
        this.numConnectionsTracked = m.getGauge(metricName);
    }

    public Observable<ObservableConnection<HttpClientResponse<O>, HttpClientRequest<I>>> connect() {
        this.observableConection = super.connect();
        return this.observableConection.doOnNext(conn -> this.trackConnection(conn.getChannel()));
    }

    protected void trackConnection(Channel channel) {
        log.info("Tracking connection: {}", (Object)channel.toString());
        this.connectionTracker.add(channel);
        this.numConnectionsTracked.increment();
    }

    protected void closeConn() {
        Iterator<Channel> iterator = this.connectionTracker.iterator();
        while (iterator.hasNext()) {
            Channel value;
            Channel channel = value = iterator.next();
            log.info("Closing connection: {}. Status at close: isActive: {}, isOpen: {}, isWritable: {}", new Object[]{channel.toString(), channel.isActive(), channel.isOpen(), channel.isWritable()});
            channel.close();
            this.numConnectionsTracked.decrement();
        }
        this.connectionTracker.clear();
    }

    protected int connectionTrackerSize() {
        return this.connectionTracker.size();
    }

    protected boolean isObservableConectionSet() {
        return this.observableConection != null;
    }
}

