/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import io.mantisrx.common.WorkerPorts;
import io.mantisrx.runtime.MachineDefinition;
import io.mantisrx.runtime.loader.config.WorkerConfiguration;
import io.mantisrx.server.agent.Hardware;
import java.util.Optional;

public class MachineDefinitionUtils {
    public static MachineDefinition sys(WorkerPorts workerPorts, double networkBandwidthInMB) {
        return new MachineDefinition((double)Hardware.getNumberCPUCores(), (double)Hardware.getSizeOfPhysicalMemory() / 1024.0 / 1024.0, networkBandwidthInMB, (double)Hardware.getSizeOfDisk() / 1024.0 / 1024.0, workerPorts.getNumberOfPorts());
    }

    public static MachineDefinition from(WorkerConfiguration workerConfiguration, WorkerPorts workerPorts) {
        return MachineDefinitionUtils.fromWorkerConfiguration(workerConfiguration, workerPorts).orElseGet(() -> MachineDefinitionUtils.sys(workerPorts, workerConfiguration.getNetworkBandwidthInMB()));
    }

    private static Optional<MachineDefinition> fromWorkerConfiguration(WorkerConfiguration workerConfiguration, WorkerPorts workerPorts) {
        if (workerConfiguration.getCpuCores() != null && workerConfiguration.getMemoryInMB() != null && workerConfiguration.getDiskInMB() != null) {
            return Optional.of(new MachineDefinition(workerConfiguration.getCpuCores().doubleValue(), workerConfiguration.getMemoryInMB().doubleValue(), workerConfiguration.getNetworkBandwidthInMB(), workerConfiguration.getDiskInMB().doubleValue(), workerPorts.getNumberOfPorts()));
        }
        return Optional.empty();
    }
}

