/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DurableBooleanState {
    private static final Logger log = LoggerFactory.getLogger(DurableBooleanState.class);
    private final String fileName;

    public DurableBooleanState(String fileName) {
        this.fileName = fileName;
        try {
            this.init();
        }
        catch (IOException e) {
            log.error("Failed to initialize the state file", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void init() throws IOException {
        if (!new File(this.fileName).exists()) {
            new File(this.fileName).createNewFile();
        }
        if (new File(this.fileName).length() == 0L) {
            byte[] contents = new byte[]{0};
            Files.write(new File(this.fileName).toPath(), contents, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    public void setState(boolean state) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(this.fileName);){
            fos.write(state ? 1 : 0);
            fos.flush();
            log.info("Set the state to {} successfully", (Object)state);
        }
    }

    public boolean getState() throws IOException {
        try (FileInputStream fis = new FileInputStream(this.fileName);){
            int state = fis.read();
            boolean bl = state != 0;
            return bl;
        }
    }
}

