/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.utils;

import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractScheduledService;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExponentialBackoffAbstractScheduledService
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ExponentialBackoffAbstractScheduledService.class);
    private final long initialDelayMillis;
    private final long maxDelayMillis;
    private int retryCount = 0;
    private long nextRunTime = 0L;

    protected ExponentialBackoffAbstractScheduledService(long initialDelayMillis, long maxDelayMillis) {
        this.initialDelayMillis = initialDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
    }

    protected abstract void runIteration() throws Exception;

    protected void runOneIteration() {
        if (!this.isTimeForNextRun()) {
            log.debug("Skipping runIteration due to retry delay. Next run after: {}", (Object)this.nextRunTime);
            return;
        }
        this.runNow();
    }

    private void runNow() {
        try {
            this.runIteration();
            this.resetRetryCount();
        }
        catch (Exception e) {
            this.onFailure();
        }
    }

    private boolean isTimeForNextRun() {
        return System.currentTimeMillis() >= this.nextRunTime;
    }

    private void onFailure() {
        ++this.retryCount;
        long delay = (long)Math.min((double)this.initialDelayMillis * Math.pow(2.0, Math.max(20, this.retryCount)), (double)this.maxDelayMillis);
        long jitter = ThreadLocalRandom.current().nextLong(delay / 2L);
        this.nextRunTime = System.currentTimeMillis() + delay + jitter;
    }

    private void resetRetryCount() {
        this.retryCount = 0;
        this.nextRunTime = 0L;
    }

    protected int getRetryCount() {
        return this.retryCount;
    }
}

