/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import io.mantisrx.server.agent.BlobStore;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopFileSystemBlobStore
implements BlobStore {
    private static final Logger log = LoggerFactory.getLogger(HadoopFileSystemBlobStore.class);
    private final FileSystem fileSystem;
    private final File localStoreDir;

    @Override
    public File get(URI blobUrl) throws IOException {
        Path src = new Path(blobUrl);
        Path dest = new Path(this.getStorageLocation(blobUrl));
        log.info("Getting file with path {}", (Object)dest);
        File destFile = new File(dest.toUri().getPath());
        if (!destFile.exists()) {
            this.fileSystem.copyToLocalFile(src, dest);
        }
        return destFile;
    }

    @Override
    public void close() throws IOException {
        FileUtils.deleteDirectory((File)this.localStoreDir);
        this.fileSystem.close();
    }

    private String getStorageLocation(URI blobUri) {
        return String.format("%s/%s", this.localStoreDir, FilenameUtils.getName((String)blobUri.getPath()));
    }

    @ConstructorProperties(value={"fileSystem", "localStoreDir"})
    public HadoopFileSystemBlobStore(FileSystem fileSystem, File localStoreDir) {
        this.fileSystem = fileSystem;
        this.localStoreDir = localStoreDir;
    }
}

