/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import io.mantisrx.server.agent.FileSystemFactory;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemInitializer {
    private static final Logger log = LoggerFactory.getLogger(FileSystemInitializer.class);
    private static final Map<String, FileSystemFactory> FS_FACTORIES = new HashMap<String, FileSystemFactory>();

    public static void initialize() {
        FS_FACTORIES.clear();
        Iterator<FileSystemFactory> fileSystemFactoryIterator = ServiceLoader.load(FileSystemFactory.class).iterator();
        fileSystemFactoryIterator.forEachRemaining(fileSystemFactory -> {
            log.info("Initializing FileSystem Factory {}", fileSystemFactory);
            FS_FACTORIES.putIfAbsent(fileSystemFactory.getScheme(), (FileSystemFactory)fileSystemFactory);
        });
    }

    public static FileSystem create(URI fsUri) throws IOException {
        FileSystemFactory factory = FS_FACTORIES.get(fsUri.getScheme());
        if (factory != null) {
            return factory.create(fsUri);
        }
        throw new IllegalArgumentException(String.format("Unknown schema %s", fsUri.getScheme()));
    }

    static {
        FileSystemInitializer.initialize();
    }
}

