/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.metrics.cgroups;

import io.mantisrx.runtime.loader.config.Usage;
import io.mantisrx.server.agent.metrics.cgroups.Cgroup;
import io.mantisrx.server.agent.metrics.cgroups.SubsystemProcess;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CpuAcctsSubsystemProcess
implements SubsystemProcess {
    private static final Logger log = LoggerFactory.getLogger(CpuAcctsSubsystemProcess.class);
    private final Cgroup cgroup;

    @Override
    public void getUsage(Usage.UsageBuilder resourceUsageBuilder) throws IOException {
        Map<String, Long> stat = this.cgroup.getStats("cpuacct", "cpuacct.stat");
        Optional<Long> user = Optional.ofNullable(stat.get("user"));
        Optional<Long> system = Optional.ofNullable(stat.get("system"));
        if (user.isPresent() && system.isPresent()) {
            resourceUsageBuilder.cpusUserTimeSecs((double)user.get().longValue());
            resourceUsageBuilder.cpusSystemTimeSecs((double)system.get().longValue());
        } else {
            log.warn("Expected metrics not found; Found stats={}", stat);
        }
        Long quota = this.cgroup.getMetric("cpuacct", "cpu.cfs_quota_us");
        Long period = this.cgroup.getMetric("cpuacct", "cpu.cfs_period_us");
        double quotaCount = 0.0;
        if (quota > -1L && period > 0L) {
            quotaCount = Math.ceil((float)quota.longValue() / (float)period.longValue());
        }
        if (quotaCount > 0.0) {
            resourceUsageBuilder.cpusLimit(quotaCount);
        } else {
            log.warn("quota={} & period={} are not configured correctly", (Object)quota, (Object)period);
        }
    }

    @ConstructorProperties(value={"cgroup"})
    CpuAcctsSubsystemProcess(Cgroup cgroup) {
        this.cgroup = cgroup;
    }
}

