/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import io.mantisrx.runtime.loader.RuntimeTask;
import io.mantisrx.runtime.loader.config.WorkerConfiguration;
import io.mantisrx.server.agent.SingleTaskOnlyFactory;
import io.mantisrx.server.agent.TaskExecutor;
import io.mantisrx.server.agent.TaskExecutorStarter;
import io.mantisrx.server.agent.config.ConfigurationFactory;
import io.mantisrx.server.agent.config.StaticPropertiesConfigurationFactory;
import io.mantisrx.server.core.Service;
import io.mantisrx.shaded.com.google.common.util.concurrent.MoreExecutors;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentV2Main
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(AgentV2Main.class);
    @Argument(alias="p", description="Specify a configuration file", required=false)
    private static String propFile = "agent.properties";
    private final TaskExecutorStarter taskExecutorStarter;
    private final AtomicBoolean stopping = new AtomicBoolean(false);

    public AgentV2Main(ConfigurationFactory configFactory) throws Exception {
        WorkerConfiguration workerConfiguration = configFactory.getConfig();
        this.taskExecutorStarter = TaskExecutorStarter.builder(workerConfiguration).taskFactory(new SingleTaskOnlyFactory()).addListener(new TaskExecutor.Listener(){

            @Override
            public void onTaskStarting(RuntimeTask task) {
            }

            @Override
            public void onTaskFailed(RuntimeTask task, Throwable throwable) {
                logger.error("Task {} failed", (Object)task, (Object)throwable);
                if (!AgentV2Main.this.isStopping()) {
                    System.exit(1);
                }
            }

            @Override
            public void onTaskCancelling(RuntimeTask task) {
            }

            @Override
            public void onTaskCancelled(RuntimeTask task, @Nullable Throwable throwable) {
                if (throwable != null) {
                    logger.error("Task {} cancellation failed", (Object)task, (Object)throwable);
                }
                if (!AgentV2Main.this.isStopping()) {
                    System.exit(1);
                }
            }
        }, MoreExecutors.directExecutor()).build();
    }

    private boolean isStopping() {
        return this.stopping.get();
    }

    public static void main(String[] args) {
        try {
            Args.parse(AgentV2Main.class, (String[])args);
        }
        catch (IllegalArgumentException e) {
            Args.usage(AgentV2Main.class);
            System.exit(1);
        }
        try {
            Properties props = new Properties();
            props.putAll(System.getenv());
            props.putAll((Map<?, ?>)System.getProperties());
            props.putAll((Map<?, ?>)AgentV2Main.loadProperties(propFile));
            StaticPropertiesConfigurationFactory factory = new StaticPropertiesConfigurationFactory(props);
            AgentV2Main agent = new AgentV2Main(factory);
            agent.start();
        }
        catch (Exception e) {
            logger.error("Unexpected error: " + e.getMessage(), (Throwable)e);
            System.exit(2);
        }
    }

    private static Properties loadProperties(String propFile) {
        Properties props = new Properties();
        try (InputStream in = AgentV2Main.findResourceAsStream(propFile);){
            props.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Can't load properties from the given property file %s: %s", propFile, e.getMessage()), e);
        }
        return props;
    }

    private static InputStream findResourceAsStream(String resourceName) throws FileNotFoundException {
        File resource = new File(resourceName);
        if (resource.exists()) {
            return new FileInputStream(resource);
        }
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName);
        if (is == null) {
            throw new FileNotFoundException(String.format("Can't find property file %s. Make sure the property file is either in your path or in your classpath ", resourceName));
        }
        return is;
    }

    public void start() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.shutdown()));
        try {
            this.taskExecutorStarter.startAsync().awaitRunning(2L, TimeUnit.MINUTES);
            this.taskExecutorStarter.awaitTerminated();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void shutdown() {
        this.stopping.set(true);
        try {
            logger.info("Received signal to shutdown; shutting down task executor");
            this.taskExecutorStarter.stopAsync().awaitTerminated(2L, TimeUnit.MINUTES);
        }
        catch (Throwable e) {
            logger.error("Failed to stop gracefully", e);
        }
    }

    public void enterActiveMode() {
    }
}

