/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import com.mantisrx.common.utils.Closeables;
import io.mantisrx.runtime.loader.ClassLoaderHandle;
import io.mantisrx.server.agent.BlobStore;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.flink.util.FlinkUserCodeClassLoader;
import org.apache.flink.util.SimpleUserCodeClassLoader;
import org.apache.flink.util.UserCodeClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlobStoreAwareClassLoaderHandle
implements ClassLoaderHandle {
    private static final Logger log = LoggerFactory.getLogger(BlobStoreAwareClassLoaderHandle.class);
    private final BlobStore blobStore;
    private final WeakHashMap<URLClassLoader, Void> openedHandles = new WeakHashMap();

    protected List<URL> getResolvedUrls(Collection<URI> requiredFiles, BlobStore blobStore) throws IOException, URISyntaxException {
        ArrayList<URL> resolvedUrls = new ArrayList<URL>();
        for (URI requiredFile : requiredFiles) {
            File file = blobStore.get(requiredFile);
            log.info("Received file {} from blob store for creating class loader", (Object)file);
            if (file.isDirectory()) {
                Collection childJarFiles = FileUtils.listFiles((File)file, (IOFileFilter)new SuffixFileFilter("jar", IOCase.INSENSITIVE), (IOFileFilter)TrueFileFilter.INSTANCE);
                log.info("Loading files {} into the class loader", (Object)childJarFiles);
                for (File jarFile : childJarFiles) {
                    resolvedUrls.add(jarFile.toURI().toURL());
                }
                continue;
            }
            resolvedUrls.add(file.toURI().toURL());
        }
        return resolvedUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserCodeClassLoader getOrResolveClassLoader(Collection<URI> requiredFiles, Collection<URL> requiredClasspaths) throws IOException {
        ArrayList<URL> resolvedUrls = new ArrayList<URL>();
        try {
            resolvedUrls.addAll(this.getResolvedUrls(requiredFiles, this.blobStore));
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        resolvedUrls.addAll(requiredClasspaths);
        ParentFirstClassLoader classLoader = new ParentFirstClassLoader(resolvedUrls.toArray(new URL[0]), this.getClass().getClassLoader(), error -> log.error("Failed to load class", error));
        WeakHashMap<URLClassLoader, Void> weakHashMap = this.openedHandles;
        synchronized (weakHashMap) {
            this.openedHandles.put((URLClassLoader)((Object)classLoader), null);
        }
        return SimpleUserCodeClassLoader.create((ClassLoader)((Object)classLoader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        WeakHashMap<URLClassLoader, Void> weakHashMap = this.openedHandles;
        synchronized (weakHashMap) {
            try {
                Closeables.combine(this.openedHandles.keySet()).close();
            }
            finally {
                this.openedHandles.clear();
                this.blobStore.close();
            }
        }
    }

    @ConstructorProperties(value={"blobStore"})
    public BlobStoreAwareClassLoaderHandle(BlobStore blobStore) {
        this.blobStore = blobStore;
    }

    public static class ParentFirstClassLoader
    extends FlinkUserCodeClassLoader {
        ParentFirstClassLoader(URL[] urls, ClassLoader parent, Consumer<Throwable> classLoadingExceptionHandler) {
            super(urls, parent, classLoadingExceptionHandler);
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

