/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.github.resilience4j.retry.event.RetryOnRetryEvent;
import io.mantisrx.common.Ack;
import io.mantisrx.common.metrics.Counter;
import io.mantisrx.common.metrics.Metrics;
import io.mantisrx.common.metrics.spectator.MetricGroupId;
import io.mantisrx.config.dynamic.LongDynamicProperty;
import io.mantisrx.server.agent.TaskExecutor;
import io.mantisrx.server.agent.utils.DurableBooleanState;
import io.mantisrx.server.agent.utils.ExponentialBackoffAbstractScheduledService;
import io.mantisrx.server.master.resourcecluster.ResourceClusterGateway;
import io.mantisrx.server.master.resourcecluster.TaskExecutorDisconnection;
import io.mantisrx.server.master.resourcecluster.TaskExecutorHeartbeat;
import io.mantisrx.server.master.resourcecluster.TaskExecutorRegistration;
import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractScheduledService;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResourceManagerGatewayCxn
extends ExponentialBackoffAbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ResourceManagerGatewayCxn.class);
    private final int idx;
    private final TaskExecutorRegistration taskExecutorRegistration;
    private volatile ResourceClusterGateway gateway;
    private final LongDynamicProperty heartBeatIntervalInMsDp;
    private final LongDynamicProperty heartBeatTimeoutInMsDp;
    private final long registrationRetryInitialDelayMillis;
    private final double registrationRetryMultiplier;
    private final double registrationRetryRandomizationFactor;
    private final int registrationRetryMaxAttempts;
    private final int tolerableConsecutiveHeartbeatFailures;
    private final TaskExecutor taskExecutor;
    private volatile boolean registered = false;
    private boolean hasRan = false;
    private final Counter heartbeatTimeoutCounter;
    private final Counter heartbeatFailureCounter;
    private final Counter taskExecutorRegistrationFailureCounter;
    private final Counter taskExecutorDisconnectionFailureCounter;
    private final Counter taskExecutorRegistrationCounter;
    private final Counter taskExecutorDisconnectionCounter;
    private final DurableBooleanState alreadyRegistered;

    ResourceManagerGatewayCxn(int idx, TaskExecutorRegistration taskExecutorRegistration, ResourceClusterGateway gateway, LongDynamicProperty heartBeatIntervalInMsDp, LongDynamicProperty heartBeatTimeoutInMsDp, TaskExecutor taskExecutor, int tolerableConsecutiveHeartbeatFailures, long heartbeatRetryInitialDelayMillis, long heartbeatRetryMaxDelayMillis, long registrationRetryInitialDelayMillis, double registrationRetryMultiplier, double registrationRetryRandomizationFactor, int registrationRetryMaxAttempts, DurableBooleanState alreadyRegistered) {
        super(heartbeatRetryInitialDelayMillis, heartbeatRetryMaxDelayMillis);
        this.tolerableConsecutiveHeartbeatFailures = tolerableConsecutiveHeartbeatFailures;
        this.idx = idx;
        this.taskExecutorRegistration = taskExecutorRegistration;
        this.gateway = gateway;
        this.heartBeatIntervalInMsDp = heartBeatIntervalInMsDp;
        this.heartBeatTimeoutInMsDp = heartBeatTimeoutInMsDp;
        this.taskExecutor = taskExecutor;
        this.registrationRetryInitialDelayMillis = registrationRetryInitialDelayMillis;
        this.registrationRetryMultiplier = registrationRetryMultiplier;
        this.registrationRetryRandomizationFactor = registrationRetryRandomizationFactor;
        this.registrationRetryMaxAttempts = registrationRetryMaxAttempts;
        this.alreadyRegistered = alreadyRegistered;
        MetricGroupId teGroupId = new MetricGroupId("TaskExecutor");
        Metrics m = new Metrics.Builder().id(teGroupId).addCounter("heartbeatTimeout").addCounter("heartbeatFailure").addCounter("taskExecutorRegistrationFailure").addCounter("taskExecutorDisconnectionFailure").addCounter("taskExecutorRegistration").addCounter("taskExecutorDisconnection").build();
        this.heartbeatTimeoutCounter = m.getCounter("heartbeatTimeout");
        this.heartbeatFailureCounter = m.getCounter("heartbeatFailure");
        this.taskExecutorRegistrationFailureCounter = m.getCounter("taskExecutorRegistrationFailure");
        this.taskExecutorDisconnectionFailureCounter = m.getCounter("taskExecutorDisconnectionFailure");
        this.taskExecutorRegistrationCounter = m.getCounter("taskExecutorRegistration");
        this.taskExecutorDisconnectionCounter = m.getCounter("taskExecutorDisconnection");
    }

    protected String serviceName() {
        return "ResourceManagerGatewayCxn-" + this.idx;
    }

    protected AbstractScheduledService.Scheduler scheduler() {
        return new AbstractScheduledService.CustomScheduler(){

            protected AbstractScheduledService.CustomScheduler.Schedule getNextSchedule() {
                return new AbstractScheduledService.CustomScheduler.Schedule(ResourceManagerGatewayCxn.this.hasRan ? (Long)ResourceManagerGatewayCxn.this.heartBeatIntervalInMsDp.getValue() : 0L, TimeUnit.MILLISECONDS);
            }
        };
    }

    public void startUp() throws Exception {
        log.info("ResourceManagerGatewayCxn starting");
    }

    private void onRegistrationRetry(RetryOnRetryEvent event) {
        log.info("Retrying task executor registration. {}", (Object)event);
        this.taskExecutorRegistrationFailureCounter.increment();
    }

    private void registerTaskExecutorWithRetry() throws Exception {
        IntervalFunction intervalFn = IntervalFunction.ofExponentialRandomBackoff((long)this.registrationRetryInitialDelayMillis, (double)this.registrationRetryMultiplier, (double)this.registrationRetryRandomizationFactor);
        RetryConfig retryConfig = RetryConfig.custom().maxAttempts(this.registrationRetryMaxAttempts).intervalFunction(intervalFn).build();
        RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
        Retry retry = retryRegistry.retry("ResourceManagerGatewayCxn:registerTaskExecutor", retryConfig);
        retry.getEventPublisher().onRetry(this::onRegistrationRetry);
        try {
            Retry.decorateCheckedSupplier((Retry)retry, this::registerTaskExecutor).apply();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private Ack registerTaskExecutor() throws ExecutionException, InterruptedException, TimeoutException {
        this.taskExecutorRegistrationCounter.increment();
        return (Ack)this.gateway.registerTaskExecutor(this.taskExecutorRegistration).get((Long)this.heartBeatTimeoutInMsDp.getValue(), TimeUnit.MILLISECONDS);
    }

    private void disconnectTaskExecutor() throws ExecutionException, InterruptedException, TimeoutException {
        this.taskExecutorDisconnectionCounter.increment();
        try {
            this.gateway.disconnectTaskExecutor(new TaskExecutorDisconnection(this.taskExecutorRegistration.getTaskExecutorID(), this.taskExecutorRegistration.getClusterID())).get(2L * (Long)this.heartBeatTimeoutInMsDp.getValue(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("Disconnection has failed", (Throwable)e);
            this.taskExecutorDisconnectionFailureCounter.increment();
            throw e;
        }
    }

    @Override
    protected void runIteration() throws Exception {
        this.hasRan = true;
        if (!this.registered && !this.alreadyRegistered.getState()) {
            log.info("Trying to register with resource manager {}", (Object)this.gateway);
            try {
                this.registerTaskExecutorWithRetry();
                this.registered = true;
                this.alreadyRegistered.setState(true);
            }
            catch (Exception e) {
                log.error("Failed to register TE: ", (Throwable)e);
                throw e;
            }
        }
        try {
            ((CompletableFuture)this.taskExecutor.getCurrentReport().thenComposeAsync(report -> {
                log.debug("Sending heartbeat to resource manager {} with report {} and timeout: {}", new Object[]{this.gateway, report, this.heartBeatTimeoutInMsDp.getValue()});
                return this.gateway.heartBeatFromTaskExecutor(new TaskExecutorHeartbeat(this.taskExecutorRegistration.getTaskExecutorID(), this.taskExecutorRegistration.getClusterID(), report));
            })).get((Long)this.heartBeatTimeoutInMsDp.getValue(), TimeUnit.MILLISECONDS);
            this.registered = true;
        }
        catch (TimeoutException e) {
            this.heartbeatTimeoutCounter.increment();
            this.handleHeartbeatFailure(e);
            throw e;
        }
        catch (Exception e) {
            this.heartbeatFailureCounter.increment();
            this.handleHeartbeatFailure(e);
            throw e;
        }
    }

    private void handleHeartbeatFailure(Exception e) throws Exception {
        log.error("Failed to send heartbeat to gateway {}", (Object)this.gateway, (Object)e);
        if (this.getRetryCount() >= this.tolerableConsecutiveHeartbeatFailures) {
            this.registered = false;
        } else {
            log.info("Ignoring heartbeat failure to gateway {} due to failed heartbeats {} <= {}", new Object[]{this.gateway, this.getRetryCount(), this.tolerableConsecutiveHeartbeatFailures});
        }
    }

    public void shutDown() throws Exception {
        this.registered = false;
        this.disconnectTaskExecutor();
    }

    public String toString() {
        return "ResourceManagerGatewayCxn(gateway=" + this.getGateway() + ")";
    }

    public ResourceClusterGateway getGateway() {
        return this.gateway;
    }

    public void setGateway(ResourceClusterGateway gateway) {
        this.gateway = gateway;
    }

    public boolean isRegistered() {
        return this.registered;
    }
}

