/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.utils;

import io.mantisrx.shaded.com.google.common.util.concurrent.AbstractScheduledService;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExponentialBackoffAbstractScheduledService
extends AbstractScheduledService {
    private static final Logger log = LoggerFactory.getLogger(ExponentialBackoffAbstractScheduledService.class);
    private final int maxRetryCount;
    private final long initialDelayMillis;
    private final long maxDelayMillis;
    private int retryCount = 0;
    private long nextRunTime = 0L;

    protected ExponentialBackoffAbstractScheduledService(int maxRetryCount, long initialDelayMillis, long maxDelayMillis) {
        this.maxRetryCount = maxRetryCount;
        this.initialDelayMillis = Math.min(initialDelayMillis, 50L);
        this.maxDelayMillis = Math.min(maxDelayMillis, 1000L);
    }

    protected abstract void runIteration() throws Exception;

    protected void runOneIteration() throws Exception {
        if (!this.isTimeForNextRun()) {
            log.debug("Skipping runIteration due to retry delay. Next run after: {}", (Object)this.nextRunTime);
            return;
        }
        this.runNow();
    }

    private void runNow() throws Exception {
        try {
            this.runIteration();
            this.resetRetryCount();
        }
        catch (Exception e) {
            this.setNextRunTime(e);
        }
    }

    private boolean isTimeForNextRun() {
        return System.currentTimeMillis() >= this.nextRunTime;
    }

    private void setNextRunTime(Exception e) throws Exception {
        if (this.retryCount >= this.maxRetryCount) {
            throw e;
        }
        long delay = (long)Math.min((double)this.initialDelayMillis * Math.pow(2.0, this.retryCount++), (double)this.maxDelayMillis);
        long jitter = ThreadLocalRandom.current().nextLong(delay / 2L);
        this.nextRunTime = System.currentTimeMillis() + delay + jitter;
    }

    private void resetRetryCount() {
        this.retryCount = 0;
        this.nextRunTime = 0L;
    }

    public boolean noMoreRetryLeft() {
        return this.retryCount >= this.maxRetryCount - 1;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public long getInitialDelayMillis() {
        return this.initialDelayMillis;
    }

    public long getMaxDelayMillis() {
        return this.maxDelayMillis;
    }

    public long getNextRunTime() {
        return this.nextRunTime;
    }

    public int getRetryCount() {
        return this.retryCount;
    }
}

