/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.metrics.cgroups;

import io.mantisrx.runtime.loader.config.Usage;
import io.mantisrx.server.agent.metrics.cgroups.Cgroup;
import io.mantisrx.server.agent.metrics.cgroups.SubsystemProcess;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CpuAcctsSubsystemProcess
implements SubsystemProcess {
    private static final Logger log = LoggerFactory.getLogger(CpuAcctsSubsystemProcess.class);
    private final Cgroup cgroup;

    @Override
    public void getUsage(Usage.UsageBuilder resourceUsageBuilder) throws IOException {
        if (this.cgroup.isV1().booleanValue()) {
            this.handleV1(resourceUsageBuilder);
        } else {
            this.handleV2(resourceUsageBuilder);
        }
    }

    private void handleV1(Usage.UsageBuilder resourceUsageBuilder) throws IOException {
        Map<String, Long> stat = this.cgroup.getStats("cpuacct", "cpuacct.stat");
        Optional<Long> user = Optional.ofNullable(stat.get("user"));
        Optional<Long> system = Optional.ofNullable(stat.get("system"));
        if (user.isPresent() && system.isPresent()) {
            resourceUsageBuilder.cpusUserTimeSecs((double)user.get().longValue() / 100.0);
            resourceUsageBuilder.cpusSystemTimeSecs((double)system.get().longValue() / 100.0);
        } else {
            log.warn("Expected metrics not found; Found stats={}", stat);
        }
        Long quota = this.cgroup.getMetric("cpuacct", "cpu.cfs_quota_us");
        Long period = this.cgroup.getMetric("cpuacct", "cpu.cfs_period_us");
        double quotaCount = 0.0;
        if (quota > -1L && period > 0L) {
            quotaCount = Math.ceil((float)quota.longValue() / (float)period.longValue());
        }
        if (quotaCount > 0.0) {
            resourceUsageBuilder.cpusLimit(quotaCount);
        } else {
            log.warn("quota={} & period={} are not configured correctly", (Object)quota, (Object)period);
        }
    }

    private void handleV2(Usage.UsageBuilder resourceUsageBuilder) throws IOException {
        Map<String, Long> cpuStats = this.cgroup.getStats("", "cpu.stat");
        resourceUsageBuilder.cpusUserTimeSecs((double)cpuStats.getOrDefault("user_usec", 0L).longValue() / 1000000.0).cpusSystemTimeSecs((double)cpuStats.getOrDefault("system_usec", 0L).longValue() / 1000000.0);
        List<Long> metrics = this.cgroup.getMetrics("", "cpu.max");
        if (metrics.size() != 2) {
            log.warn("cpu.max metrics={} are not configured correctly", metrics);
        } else {
            Long quota = metrics.get(0);
            Long period = metrics.get(1);
            resourceUsageBuilder.cpusLimit((double)((float)quota.longValue() / (float)period.longValue()));
        }
    }

    @ConstructorProperties(value={"cgroup"})
    CpuAcctsSubsystemProcess(Cgroup cgroup) {
        this.cgroup = cgroup;
    }
}

