/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.metrics.cgroups;

import io.mantisrx.runtime.loader.config.MetricsCollector;
import io.mantisrx.runtime.loader.config.Usage;
import io.mantisrx.server.agent.metrics.cgroups.CgroupImpl;
import io.mantisrx.server.agent.metrics.cgroups.CpuAcctsSubsystemProcess;
import io.mantisrx.server.agent.metrics.cgroups.MemorySubsystemProcess;
import io.mantisrx.server.agent.metrics.cgroups.NetworkSubsystemProcess;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CgroupsMetricsCollector
implements MetricsCollector {
    private static final Logger log = LoggerFactory.getLogger(CgroupsMetricsCollector.class);
    private final CpuAcctsSubsystemProcess cpu;
    private final MemorySubsystemProcess memory;
    private final NetworkSubsystemProcess network;

    public static CgroupsMetricsCollector valueOf(Properties properties) {
        String cgroupPath = properties.getProperty("mantis.cgroups.path", "/sys/fs/cgroup");
        String networkIfacePath = properties.getProperty("mantis.cgroups.networkPath", "/proc/net/dev");
        String interfaceName = properties.getProperty("mantis.cgroups.interface", "eth0:");
        return new CgroupsMetricsCollector(cgroupPath, networkIfacePath, interfaceName);
    }

    public CgroupsMetricsCollector(String cgroupPath, String networkIfacePath, String interfaceName) {
        CgroupImpl cgroup = new CgroupImpl(cgroupPath);
        this.cpu = new CpuAcctsSubsystemProcess(cgroup);
        this.memory = new MemorySubsystemProcess(cgroup);
        this.network = new NetworkSubsystemProcess(networkIfacePath, interfaceName);
    }

    public Usage get() throws IOException {
        try {
            Usage.UsageBuilder usageBuilder = Usage.builder();
            this.cpu.getUsage(usageBuilder);
            this.memory.getUsage(usageBuilder);
            this.network.getUsage(usageBuilder);
            return usageBuilder.build();
        }
        catch (Exception ex) {
            log.warn("Failed to get usage: ", (Throwable)ex);
            return Usage.builder().build();
        }
    }

    @ConstructorProperties(value={"cpu", "memory", "network"})
    public CgroupsMetricsCollector(CpuAcctsSubsystemProcess cpu, MemorySubsystemProcess memory, NetworkSubsystemProcess network) {
        this.cpu = cpu;
        this.memory = memory;
        this.network = network;
    }
}

