/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent;

import io.mantisrx.server.agent.FileSystemInitializer;
import io.mantisrx.server.agent.HadoopFileSystemBlobStore;
import io.mantisrx.shaded.com.google.common.util.concurrent.Striped;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.concurrent.locks.Lock;
import net.lingala.zip4j.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.hadoop.fs.FileSystem;

public interface BlobStore
extends Closeable {
    public File get(URI var1) throws IOException;

    default public BlobStore withPrefix(URI prefixUri) {
        return new PrefixedBlobStore(prefixUri, this);
    }

    default public BlobStore withZipCapabilities() {
        return new ZipHandlingBlobStore(this);
    }

    default public BlobStore withThreadSafeBlobStore() {
        return new ThreadSafeBlobStore(this);
    }

    public static BlobStore forHadoopFileSystem(URI clusterStoragePath, File localStoreDir) throws Exception {
        FileSystem fileSystem = FileSystemInitializer.create(clusterStoragePath);
        return new HadoopFileSystemBlobStore(fileSystem, localStoreDir).withPrefix(clusterStoragePath).withZipCapabilities().withThreadSafeBlobStore();
    }

    public static class ThreadSafeBlobStore
    implements BlobStore {
        private final BlobStore blobStore;
        final Striped<Lock> locks = Striped.lock((int)1024);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public File get(URI blobUrl) throws IOException {
            Lock lock = (Lock)this.locks.get((Object)blobUrl.getPath());
            lock.lock();
            try {
                File file = this.blobStore.get(blobUrl);
                return file;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        public void close() throws IOException {
            this.blobStore.close();
        }

        @ConstructorProperties(value={"blobStore"})
        ThreadSafeBlobStore(BlobStore blobStore) {
            this.blobStore = blobStore;
        }
    }

    public static class ZipHandlingBlobStore
    implements BlobStore {
        private final BlobStore blobStore;

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public File get(URI blobUrl) throws IOException {
            File localFile = this.blobStore.get(blobUrl);
            ZipFile zipFile = this.getZipFile(localFile);
            if (zipFile == null) {
                return localFile;
            }
            File destDir = null;
            try (ZipFile z = zipFile;){
                String destDirStr = this.getUnzippedDestDir(z);
                destDir = new File(destDirStr);
                if (destDir.exists()) {
                    File file = destDir;
                    return file;
                }
                z.extractAll(destDirStr);
                File file = destDir;
                return file;
            }
            catch (Exception e) {
                if (destDir == null) throw e;
                FileUtils.deleteDirectory(destDir);
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            this.blobStore.close();
        }

        private String getUnzippedDestDir(ZipFile zipFile) {
            return zipFile.getFile().getPath() + "-unzipped";
        }

        private ZipFile getZipFile(File file) {
            ZipFile file1 = new ZipFile(file);
            if (file1.isValidZipFile()) {
                return file1;
            }
            return null;
        }

        @ConstructorProperties(value={"blobStore"})
        ZipHandlingBlobStore(BlobStore blobStore) {
            this.blobStore = blobStore;
        }
    }

    public static class PrefixedBlobStore
    implements BlobStore {
        private final URI rootUri;
        private final BlobStore blobStore;

        @Override
        public File get(URI blobUrl) throws IOException {
            String fileName = FilenameUtils.getName((String)blobUrl.toString());
            return this.blobStore.get(this.rootUri.resolve(fileName));
        }

        @Override
        public void close() throws IOException {
            this.blobStore.close();
        }

        @ConstructorProperties(value={"rootUri", "blobStore"})
        PrefixedBlobStore(URI rootUri, BlobStore blobStore) {
            this.rootUri = rootUri;
            this.blobStore = blobStore;
        }
    }
}

