/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.server.agent.metrics.cgroups;

import io.mantisrx.server.agent.metrics.cgroups.Cgroup;
import io.mantisrx.shaded.org.apache.curator.shaded.com.google.common.base.Preconditions;
import io.vavr.Tuple2;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.stream.Collectors;

public class CgroupImpl
implements Cgroup {
    private final String path;

    @Override
    public Long getMetric(String subsystem, String metricName) throws IOException {
        Path metricPath = Paths.get(this.path, subsystem, metricName);
        try {
            return Files.readAllLines(metricPath).stream().findFirst().map(Long::valueOf).get();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public Map<String, Long> getStats(String subsystem, String stat) throws IOException {
        Path statPath = Paths.get(this.path, subsystem, stat);
        return Files.readAllLines(statPath).stream().map(l -> {
            String[] parts = l.split("\\s+");
            Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Expected two parts only but was {} parts", (Object[])new Object[]{parts.length});
            return new Tuple2((Object)parts[0], (Object)Long.parseLong(parts[1]));
        }).collect(Collectors.toMap(t -> (String)t._1, t -> (Long)t._2));
    }

    @ConstructorProperties(value={"path"})
    public CgroupImpl(String path) {
        this.path = path;
    }
}

