/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.control.controllers;

import io.mantisrx.control.IController;
import io.mantisrx.shaded.com.google.common.util.concurrent.AtomicDouble;

public class PIDController
extends IController {
    private final Double kp;
    private final Double ki;
    private final Double kd;
    private Double previous = 0.0;
    private final double deltaT;
    private final AtomicDouble dampener;
    private final double integralDecay;
    private Double integral = 0.0;
    private Double derivative = 0.0;

    public PIDController(Double kp, Double ki, Double kd, Double deltaT, AtomicDouble dampener, double integralDecay) {
        this.kp = kp;
        this.ki = ki;
        this.kd = kd;
        this.deltaT = deltaT;
        this.dampener = dampener;
        this.integralDecay = integralDecay;
    }

    public PIDController(Double kp, Double ki, Double kd) {
        this(kp, ki, kd, 1.0, new AtomicDouble(1.0), 1.0);
    }

    @Override
    public Double processStep(Double error) {
        double curIntegral = this.integral + this.deltaT * error;
        this.derivative = (error - this.previous) / this.deltaT;
        this.previous = error;
        this.integral = this.integralDecay * curIntegral;
        double d = this.dampener.get();
        return this.kp * d * error + this.ki * d * curIntegral + this.kd * d * this.derivative;
    }

    @Deprecated
    public static PIDController of(Double kp, Double ki, Double kd, AtomicDouble dampener) {
        return new PIDController(kp, ki, kd, 1.0, dampener, 1.0);
    }

    @Deprecated
    public static PIDController of(Double kp, Double ki, Double kd, Double deltaT) {
        return new PIDController(kp, ki, kd, deltaT, new AtomicDouble(1.0), 1.0);
    }

    @Deprecated
    public static PIDController of(Double kp, Double ki, Double kd) {
        return new PIDController(kp, ki, kd, 1.0, new AtomicDouble(1.0), 1.0);
    }

    public AtomicDouble getDampener() {
        return this.dampener;
    }

    public double getIntegralDecay() {
        return this.integralDecay;
    }
}

