/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.control.clutch;

import io.mantisrx.control.IController;
import io.mantisrx.shaded.com.google.common.cache.Cache;
import io.mantisrx.shaded.com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class OscillationDetector
extends IController {
    private final Cache<Long, Double> history;
    private Double previous = -1.0;
    private final Consumer<Double> callback;

    public OscillationDetector(int historyMinutes, Consumer<Double> callback) {
        this.history = CacheBuilder.newBuilder().maximumSize(12L).expireAfterWrite((long)historyMinutes, TimeUnit.MINUTES).build();
        this.callback = callback;
    }

    @Override
    protected Double processStep(Double scale) {
        this.previous = this.previous == null ? scale : this.previous;
        double delta = scale > this.previous ? 1.0 : -1.0;
        this.previous = scale;
        this.history.put((Object)System.currentTimeMillis(), (Object)delta);
        this.callback.accept(this.computeOscillationFactor(this.history));
        return scale;
    }

    private double computeOscillationFactor(Cache<Long, Double> actionCache) {
        long nDown;
        long nUp = actionCache.asMap().values().stream().filter(x -> x > 0.0).count();
        long n = nUp + (nDown = actionCache.asMap().values().stream().filter(x -> x < 0.0).count());
        return n == 0L ? 1.0 : (nUp > nDown ? 1.0 * (double)nUp / (double)n : 1.0 * (double)nDown / (double)n);
    }
}

