/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.control.clutch;

import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.mantisrx.control.clutch.Clutch;
import io.mantisrx.control.clutch.ClutchConfiguration;
import io.mantisrx.control.clutch.Event;
import io.mantisrx.control.clutch.metrics.IClutchMetricsRegistry;
import io.vavr.Function1;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ExperimentalClutchConfigurator
implements Observable.Transformer<Event, ClutchConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ExperimentalClutchConfigurator.class);
    private static int DEFAULT_K = 1024;
    private static int NUM_STATS_DATA_POINTS = (int)TimeUnit.DAYS.toMinutes(7L) * 2;
    private IClutchMetricsRegistry metricsRegistry;
    private final Observable<Long> timer;
    private final long initialConfigMilis;
    private final Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator;
    private static ConcurrentHashMap<Clutch.Metric, UpdateDoublesSketch> sketches = new ConcurrentHashMap();
    private static ConcurrentHashMap<Clutch.Metric, DescriptiveStatistics> stats = new ConcurrentHashMap();

    public ExperimentalClutchConfigurator(IClutchMetricsRegistry metricsRegistry, Observable<Long> timer, long initialConfigMillis, Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator) {
        this.metricsRegistry = metricsRegistry;
        this.timer = timer;
        this.initialConfigMilis = initialConfigMillis;
        this.configurator = configurator;
    }

    private ClutchConfiguration getConfig() {
        return (ClutchConfiguration)this.configurator.apply(sketches);
    }

    public Observable<ClutchConfiguration> call(Observable<Event> eventObservable) {
        Observable configs = this.timer.map(__ -> this.getConfig()).doOnNext(config -> log.info("New Config: {}", (Object)config.toString()));
        Observable initialConfig = Observable.interval((long)this.initialConfigMilis, (TimeUnit)TimeUnit.MILLISECONDS).take(1).map(__ -> this.getConfig()).doOnNext(config -> log.info("Initial Config: {}", (Object)config.toString()));
        eventObservable.filter(event -> event != null && event.metric != null).map(event -> {
            UpdateDoublesSketch sketch = sketches.computeIfAbsent(event.metric, metric -> UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
            sketch.update(event.value);
            DescriptiveStatistics stat = stats.computeIfAbsent(event.metric, metric -> new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
            stat.addValue(event.value);
            return null;
        }).subscribe();
        return initialConfig.concatWith(configs).distinctUntilChanged().doOnNext(__ -> log.info("RPS Sketch State: {}", (Object)sketches.get((Object)Clutch.Metric.RPS))).doOnNext(__ -> {
            ExperimentalClutchConfigurator.logSketchSummary((DoublesSketch)sketches.get((Object)Clutch.Metric.RPS));
            ExperimentalClutchConfigurator.logStatsSummary(stats.get((Object)Clutch.Metric.RPS), "Stats RPS metric: ");
            ExperimentalClutchConfigurator.logStatsSummary(stats.get((Object)Clutch.Metric.CPU), "Stats CPU metric: ");
            ExperimentalClutchConfigurator.logStatsSummary(stats.get((Object)Clutch.Metric.MEMORY), "Stats Memory metric: ");
            ExperimentalClutchConfigurator.logStatsSummary(stats.get((Object)Clutch.Metric.NETWORK), "Stats Network metric: ");
        }).doOnNext(config -> log.info("Clutch switched to config: {}", config));
    }

    private static void logSketchSummary(DoublesSketch sketch) {
        double[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.25, 0.5, 0.75, 0.99, 1.0});
        log.info("RPS Sketch Quantiles -- Min: {}, 25th: {}, 50th: {}, 75th: {}, 99th: {}, Max: {}", new Object[]{quantiles[0], quantiles[1], quantiles[2], quantiles[3], quantiles[4], quantiles[5]});
    }

    private static void logStatsSummary(DescriptiveStatistics stat, String prefix) {
        log.info("{} RPS Sketch Quantiles -- Min: {}, 25th: {}, 50th: {}, 75th: {}, 99th: {}, Max: {}", new Object[]{prefix, stat.getPercentile(0.0), stat.getPercentile(25.0), stat.getPercentile(50.0), stat.getPercentile(75.0), stat.getPercentile(99.0), stat.getPercentile(100.0)});
    }

    static {
        sketches.put(Clutch.Metric.CPU, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.MEMORY, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.NETWORK, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.LAG, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.DROPS, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.UserDefined, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.RPS, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.SOURCEJOB_DROP, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        stats.put(Clutch.Metric.CPU, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
        stats.put(Clutch.Metric.MEMORY, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
        stats.put(Clutch.Metric.NETWORK, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
        stats.put(Clutch.Metric.LAG, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
        stats.put(Clutch.Metric.DROPS, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
        stats.put(Clutch.Metric.UserDefined, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
        stats.put(Clutch.Metric.RPS, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
        stats.put(Clutch.Metric.SOURCEJOB_DROP, new DescriptiveStatistics(NUM_STATS_DATA_POINTS));
    }
}

