/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.control.clutch;

import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.mantisrx.control.IActuator;
import io.mantisrx.control.clutch.Clutch;
import io.mantisrx.control.clutch.ClutchConfiguration;
import io.mantisrx.control.clutch.Event;
import io.mantisrx.control.clutch.ExperimentalClutchConfigurator;
import io.mantisrx.control.clutch.ExperimentalControlLoop;
import io.mantisrx.control.clutch.IRpsMetricComputer;
import io.mantisrx.control.clutch.IScaleComputer;
import io.mantisrx.control.clutch.metrics.IClutchMetricsRegistry;
import io.mantisrx.shaded.com.google.common.util.concurrent.AtomicDouble;
import io.vavr.Function1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;

public class ClutchExperimental
implements Observable.Transformer<Event, Object> {
    private final IActuator actuator;
    private final AtomicLong currentSize;
    private final Integer minSize;
    private final Integer maxSize;
    private final Observable<Long> timer;
    private final Observable<Integer> sizeObs;
    private final long initialConfigMillis;
    private final Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator;
    private final IRpsMetricComputer rpsMetricComputer;
    private final IScaleComputer scaleComputer;

    public ClutchExperimental(IActuator actuator, Integer initialSize, Integer minSize, Integer maxSize, Observable<Integer> sizeObs, Observable<Long> timer, long initialConfigMillis, Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator, IRpsMetricComputer rpsMetricComputer, IScaleComputer scaleComputer) {
        this.actuator = actuator;
        this.currentSize = new AtomicLong(initialSize.intValue());
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.sizeObs = sizeObs;
        this.timer = timer;
        this.initialConfigMillis = initialConfigMillis;
        this.configurator = configurator;
        this.rpsMetricComputer = rpsMetricComputer;
        this.scaleComputer = scaleComputer;
    }

    public ClutchExperimental(IActuator actuator, Integer currentSize, Integer minSize, Integer maxSize, Observable<Integer> sizeObs, Observable<Long> timer, long initialConfigMillis, Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator) {
        this(actuator, currentSize, minSize, maxSize, sizeObs, timer, initialConfigMillis, configurator, new ExperimentalControlLoop.DefaultRpsMetricComputer(), new ExperimentalControlLoop.DefaultScaleComputer());
    }

    public ClutchExperimental(IActuator actuator, Integer currentSize, Integer minSize, Integer maxSize, Observable<Integer> sizeObs, Observable<Long> timer, long initialConfigMillis, long coolDownSeconds) {
        this(actuator, currentSize, minSize, maxSize, sizeObs, timer, initialConfigMillis, (Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration>)(Function1 & Serializable)sketches -> {
            double setPoint = 0.6 * ((UpdateDoublesSketch)sketches.get((Object)Clutch.Metric.RPS)).getQuantile(0.99);
            Tuple2 rope = Tuple.of((Object)(setPoint * 0.15), (Object)0.0);
            double kp = setPoint * 1.0E-9 / 5.0;
            double ki = 0.0;
            double kd = setPoint * 1.0E-9 / 4.0;
            return new ClutchConfiguration.ClutchConfigurationBuilder().metric(Clutch.Metric.RPS).setPoint(setPoint).kp(kp).ki(ki).kd(kd).minSize(minSize).maxSize(maxSize).rope((Tuple2<Double, Double>)rope).cooldownInterval(coolDownSeconds).cooldownUnits(TimeUnit.SECONDS).build();
        });
    }

    public Observable<Object> call(Observable<Event> eventObservable) {
        Observable events = eventObservable.share();
        return events.compose((Observable.Transformer)new ExperimentalClutchConfigurator(new IClutchMetricsRegistry(){}, this.timer, this.initialConfigMillis, this.configurator)).switchMap(config -> events.compose((Observable.Transformer)new ExperimentalControlLoop((ClutchConfiguration)config, this.actuator, this.currentSize, new AtomicDouble(1.0), this.timer, this.sizeObs, this.rpsMetricComputer, this.scaleComputer)));
    }
}

