/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.control.clutch;

import io.mantisrx.control.IActuator;
import io.mantisrx.control.clutch.Clutch;
import io.mantisrx.control.clutch.ClutchConfiguration;
import io.mantisrx.control.clutch.Event;
import io.mantisrx.control.clutch.IRpsMetricComputer;
import io.mantisrx.control.clutch.IScaleComputer;
import io.mantisrx.control.controllers.ErrorComputer;
import io.mantisrx.control.controllers.Integrator;
import io.mantisrx.control.controllers.PIDController;
import io.mantisrx.shaded.com.google.common.util.concurrent.AtomicDouble;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscription;

public class ExperimentalControlLoop
implements Observable.Transformer<Event, Double> {
    private static final Logger log = LoggerFactory.getLogger(ExperimentalControlLoop.class);
    private final ClutchConfiguration config;
    private final IActuator actuator;
    private final AtomicDouble dampener;
    private final AtomicLong cooldownTimestamp;
    private final AtomicLong currentSize;
    private final AtomicDouble lastLag;
    private final Observable<Integer> size;
    private final IRpsMetricComputer rpsMetricComputer;
    private final IScaleComputer scaleComputer;
    private long cooldownMillis;

    public ExperimentalControlLoop(ClutchConfiguration config, IActuator actuator, AtomicLong currentSize, Observable<Long> timer, Observable<Integer> size) {
        this(config, actuator, currentSize, new AtomicDouble(1.0), timer, size, new DefaultRpsMetricComputer(), new DefaultScaleComputer());
    }

    public ExperimentalControlLoop(ClutchConfiguration config, IActuator actuator, AtomicLong currentSize, AtomicDouble dampener, Observable<Long> timer, Observable<Integer> size, IRpsMetricComputer rpsMetricComputer, IScaleComputer scaleComputer) {
        this.config = config;
        this.actuator = actuator;
        this.dampener = dampener;
        this.cooldownMillis = config.getCooldownUnits().toMillis(config.cooldownInterval);
        this.cooldownTimestamp = new AtomicLong(System.currentTimeMillis());
        this.currentSize = currentSize;
        this.lastLag = new AtomicDouble(0.0);
        this.size = size;
        this.rpsMetricComputer = rpsMetricComputer;
        this.scaleComputer = scaleComputer;
    }

    public Observable<Double> call(Observable<Event> events) {
        events = events.share();
        Observable lag = Observable.just((Object)new Event(Clutch.Metric.LAG, 0.0)).mergeWith(events.filter(event -> event.getMetric() == Clutch.Metric.LAG));
        Observable drops = Observable.just((Object)new Event(Clutch.Metric.DROPS, 0.0)).mergeWith(events.filter(event -> event.getMetric() == Clutch.Metric.DROPS));
        Observable sourceJobDrops = Observable.just((Object)new Event(Clutch.Metric.SOURCEJOB_DROP, 0.0)).mergeWith(events.filter(event -> event.getMetric() == Clutch.Metric.SOURCEJOB_DROP));
        Observable rps = events.filter(event -> event.getMetric() == Clutch.Metric.RPS);
        Integrator deltaIntegrator = new Integrator(0.0, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, this.config.integralDecay);
        Subscription sizeSub = this.size.doOnNext(this.currentSize::set).doOnNext(__ -> this.cooldownTimestamp.set(System.currentTimeMillis())).doOnNext(n -> log.info("Clutch received new scheduling update with {} workers.", n)).subscribe();
        return rps.withLatestFrom(lag, drops, sourceJobDrops, (rpsEvent, lagEvent, dropEvent, sourceDropEvent) -> {
            HashMap<Clutch.Metric, Double> metrics = new HashMap<Clutch.Metric, Double>();
            metrics.put(rpsEvent.getMetric(), rpsEvent.getValue());
            metrics.put(lagEvent.getMetric(), lagEvent.getValue());
            metrics.put(dropEvent.getMetric(), dropEvent.getValue());
            metrics.put(sourceDropEvent.getMetric(), sourceDropEvent.getValue());
            return metrics;
        }).doOnNext(metrics -> log.info("Latest metrics: {}", metrics)).map(metrics -> (Double)this.rpsMetricComputer.apply(this.config, metrics)).lift((Observable.Operator)new ErrorComputer(this.config.setPoint, true, (Double)this.config.rope._1, (Double)this.config.rope._2)).lift((Observable.Operator)new PIDController(this.config.kp, this.config.ki, this.config.kd, 1.0, new AtomicDouble(1.0), this.config.integralDecay)).doOnNext(d -> log.info("PID controller output: {}", d)).lift((Observable.Operator)deltaIntegrator).doOnNext(d -> log.info("Integral: {}", d)).filter(__ -> this.cooldownMillis == 0L || this.cooldownTimestamp.get() <= System.currentTimeMillis() - this.cooldownMillis).map(delta -> (Double)this.scaleComputer.apply(this.config, this.currentSize.get(), delta)).doOnNext(d -> log.info("New desired size: {}, existing size: {}", d, (Object)this.currentSize.get())).filter(scale -> this.currentSize.get() != Math.round(Math.ceil(scale))).lift((Observable.Operator)this.actuator).doOnNext(scale -> this.currentSize.set(Math.round(Math.ceil(scale)))).doOnNext(__ -> deltaIntegrator.setSum(0.0)).doOnNext(__ -> this.cooldownTimestamp.set(System.currentTimeMillis())).doOnUnsubscribe(() -> sizeSub.unsubscribe());
    }

    protected void setCooldownMillis(long cooldownMillis) {
        this.cooldownMillis = cooldownMillis;
    }

    public static class DefaultScaleComputer
    implements IScaleComputer {
        public Double apply(ClutchConfiguration config, Long currentScale, Double delta) {
            return Math.min((double)config.maxSize, Math.max((double)config.minSize, (double)currentScale.longValue() + delta));
        }
    }

    public static class DefaultRpsMetricComputer
    implements IRpsMetricComputer {
        private double lastLag = 0.0;

        public Double apply(ClutchConfiguration config, Map<Clutch.Metric, Double> metrics) {
            double rps = metrics.get((Object)Clutch.Metric.RPS);
            double lag = metrics.get((Object)Clutch.Metric.LAG);
            double sourceDrops = metrics.get((Object)Clutch.Metric.SOURCEJOB_DROP);
            double drops = metrics.get((Object)Clutch.Metric.DROPS);
            double lagDerivative = lag - this.lastLag;
            this.lastLag = lag;
            return rps + lagDerivative + sourceDrops + drops;
        }
    }
}

