/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.controllers;

import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.control.IActuator;
import com.netflix.control.clutch.Clutch;
import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.Event;
import com.netflix.control.controllers.ErrorComputer;
import com.netflix.control.controllers.Integrator;
import com.netflix.control.controllers.PIDController;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ControlLoop
implements Observable.Transformer<Event, Double> {
    private static final Logger log = LoggerFactory.getLogger(ControlLoop.class);
    private final ClutchConfiguration config;
    private final IActuator actuator;
    private final Double initialSize;
    private final AtomicDouble dampener;
    private final AtomicLong currentScale;
    private final long cooldownMillis;
    private final AtomicLong cooldownTimestamp;
    private final UpdateDoublesSketch sketch = UpdateDoublesSketch.builder().setK(1024).build();

    public ControlLoop(ClutchConfiguration config, IActuator actuator, Double initialSize) {
        this(config, actuator, initialSize, new AtomicDouble(1.0));
    }

    public ControlLoop(ClutchConfiguration config, IActuator actuator, Double initialSize, AtomicDouble dampener) {
        this.config = config;
        this.actuator = actuator;
        this.initialSize = initialSize;
        this.currentScale = new AtomicLong(Math.round(initialSize));
        this.dampener = dampener;
        this.cooldownMillis = config.getCooldownUnits().toMillis(config.cooldownInterval);
        this.cooldownTimestamp = new AtomicLong(System.currentTimeMillis() + this.cooldownMillis);
    }

    public Observable<Double> call(Observable<Event> events) {
        events = events.share();
        Observable lag = events.filter(event -> event.getMetric() == Clutch.Metric.LAG);
        Observable drops = events.filter(event -> event.getMetric() == Clutch.Metric.DROPS);
        return events.filter(e -> e.metric == this.config.metric).map(e -> e.value).doOnNext(arg_0 -> ((UpdateDoublesSketch)this.sketch).update(arg_0)).lift((Observable.Operator)new ErrorComputer(this.config.setPoint, true, (Double)this.config.rope._1, (Double)this.config.rope._2)).lift((Observable.Operator)PIDController.of(this.config.kp, this.config.ki, this.config.kd)).lift((Observable.Operator)new Integrator(this.initialSize, this.config.minSize, this.config.maxSize)).filter(__ -> this.cooldownMillis == 0L || this.cooldownTimestamp.get() <= System.currentTimeMillis() - this.cooldownMillis).filter(scale -> this.currentScale.get() != Math.round(Math.ceil(scale))).lift((Observable.Operator)this.actuator).doOnNext(scale -> this.currentScale.set(Math.round(Math.ceil(scale)))).doOnNext(__ -> this.cooldownTimestamp.set(System.currentTimeMillis()));
    }
}

