/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.controllers;

import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.control.IController;

public class PIDController
extends IController {
    private final Double kp;
    private final Double ki;
    private final Double kd;
    private Double previous = 0.0;
    private final double deltaT;
    private final AtomicDouble dampener;
    private Double integral = 0.0;
    private Double derivative = 0.0;

    public PIDController(Double kp, Double ki, Double kd, Double deltaT, AtomicDouble dampener) {
        this.kp = kp;
        this.ki = ki;
        this.kd = kd;
        this.deltaT = deltaT;
        this.dampener = dampener;
    }

    public PIDController(Double kp, Double ki, Double kd, Double deltaT) {
        this(kp, ki, kd, deltaT, new AtomicDouble(1.0));
    }

    @Override
    public Double processStep(Double error) {
        PIDController pIDController = this;
        pIDController.integral = pIDController.integral + this.deltaT * error;
        this.derivative = (error - this.previous) / this.deltaT;
        this.previous = error;
        double d = this.dampener.get();
        return this.kp * d * error + this.ki * d * this.integral + this.kd * d * this.derivative;
    }

    public static PIDController of(Double kp, Double ki, Double kd, AtomicDouble dampener) {
        return new PIDController(kp, ki, kd, 1.0, dampener);
    }

    public static PIDController of(Double kp, Double ki, Double kd, Double deltaT) {
        return new PIDController(kp, ki, kd, deltaT);
    }

    public static PIDController of(Double kp, Double ki, Double kd) {
        return new PIDController(kp, ki, kd, 1.0, new AtomicDouble(1.0));
    }

    public AtomicDouble getDampener() {
        return this.dampener;
    }
}

