/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.actuators;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.netflix.control.IActuator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MantisJobActuator
extends IActuator {
    private final String jobId;
    private final Integer stageNumber;
    private static Logger logger = LoggerFactory.getLogger(MantisJobActuator.class);
    private Long lastValue = Long.MIN_VALUE;
    private final String url;
    private final String scaleEndPoint = "/api/jobs/scaleStage";

    public MantisJobActuator(String jobId, Integer stageNumber, String environ, String region, String stack) {
        this.jobId = jobId;
        this.stageNumber = stageNumber;
        this.url = "staging".equals(stack.toLowerCase()) ? "https://mantisapi.staging." + region + "." + environ + ".netflix.net" : "https://mantisapi." + region + "." + environ + ".netflix.net";
        logger.debug("Using scaling endpoint: " + this.url);
    }

    @Override
    protected Double processStep(Double input) {
        Long numWorkers = Double.valueOf(Math.ceil(input)).longValue();
        if (numWorkers != this.lastValue) {
            logger.info("Scaling " + this.jobId + " to " + numWorkers + " workers.");
            String payload = "{\"JobId\":\"" + this.jobId + "\",\"StageNumber\":" + this.stageNumber + ",\"NumWorkers\":\"" + numWorkers + "\"}";
            try {
                HttpResponse httpResponse = Unirest.post((String)(this.url + "/api/jobs/scaleStage")).header("accept", "application/json").body(payload).asString();
            }
            catch (Exception ex) {
                System.out.println(ex.getMessage());
            }
            this.lastValue = numWorkers;
        }
        return (double)numWorkers.longValue() * 1.0;
    }
}

