/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.clutch;

import com.netflix.control.IActuator;
import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.Event;
import com.netflix.control.clutch.ExperimentalClutchConfigurator;
import com.netflix.control.clutch.ExperimentalControlLoop;
import com.netflix.control.clutch.metrics.IClutchMetricsRegistry;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public class ClutchExperimental
implements Observable.Transformer<Event, Object> {
    private final IActuator actuator;
    private final Integer initialSize;
    private final Integer minSize;
    private final Integer maxSize;
    private final Observable<Long> timer;
    private final Observable<Integer> size;
    private final long initialConfigMillis;

    public ClutchExperimental(IActuator actuator, Integer initialSize, Integer minSize, Integer maxSize, Observable<Integer> size) {
        this(actuator, initialSize, minSize, maxSize, size, (Observable<Long>)Observable.interval((long)1L, (TimeUnit)TimeUnit.DAYS), 600000L);
    }

    public ClutchExperimental(IActuator actuator, Integer initialSize, Integer minSize, Integer maxSize, Observable<Integer> size, Observable<Long> timer, long initialConfigMillis) {
        this.actuator = actuator;
        this.initialSize = initialSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.size = size;
        this.timer = timer;
        this.initialConfigMillis = initialConfigMillis;
    }

    public Observable<Object> call(Observable<Event> eventObservable) {
        Observable events = eventObservable.share();
        return events.compose((Observable.Transformer)new ExperimentalClutchConfigurator(new IClutchMetricsRegistry(){}, this.minSize, this.maxSize, this.timer, this.initialConfigMillis)).flatMap(config -> events.compose((Observable.Transformer)new ExperimentalControlLoop((ClutchConfiguration)config, this.actuator, this.initialSize.doubleValue(), this.size)).takeUntil(this.timer));
    }
}

