/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.clutch;

import com.netflix.control.clutch.Clutch;
import io.vavr.Tuple2;
import java.util.concurrent.TimeUnit;

public final class ClutchConfiguration {
    public final Clutch.Metric metric;
    public final double setPoint;
    public final double kp;
    public final double ki;
    public final double kd;
    public final int minSize;
    public final int maxSize;
    public final Tuple2<Double, Double> rope;
    public final long cooldownInterval;
    public final TimeUnit cooldownUnits;

    ClutchConfiguration(Clutch.Metric metric, double setPoint, double kp, double ki, double kd, int minSize, int maxSize, Tuple2<Double, Double> rope, long cooldownInterval, TimeUnit cooldownUnits) {
        this.metric = metric;
        this.setPoint = setPoint;
        this.kp = kp;
        this.ki = ki;
        this.kd = kd;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.rope = rope;
        this.cooldownInterval = cooldownInterval;
        this.cooldownUnits = cooldownUnits;
    }

    public static ClutchConfigurationBuilder builder() {
        return new ClutchConfigurationBuilder();
    }

    public Clutch.Metric getMetric() {
        return this.metric;
    }

    public double getSetPoint() {
        return this.setPoint;
    }

    public double getKp() {
        return this.kp;
    }

    public double getKi() {
        return this.ki;
    }

    public double getKd() {
        return this.kd;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public Tuple2<Double, Double> getRope() {
        return this.rope;
    }

    public long getCooldownInterval() {
        return this.cooldownInterval;
    }

    public TimeUnit getCooldownUnits() {
        return this.cooldownUnits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClutchConfiguration)) {
            return false;
        }
        ClutchConfiguration other = (ClutchConfiguration)o;
        Clutch.Metric this$metric = this.getMetric();
        Clutch.Metric other$metric = other.getMetric();
        if (this$metric == null ? other$metric != null : !((Object)((Object)this$metric)).equals((Object)other$metric)) {
            return false;
        }
        if (Double.compare(this.getSetPoint(), other.getSetPoint()) != 0) {
            return false;
        }
        if (Double.compare(this.getKp(), other.getKp()) != 0) {
            return false;
        }
        if (Double.compare(this.getKi(), other.getKi()) != 0) {
            return false;
        }
        if (Double.compare(this.getKd(), other.getKd()) != 0) {
            return false;
        }
        if (this.getMinSize() != other.getMinSize()) {
            return false;
        }
        if (this.getMaxSize() != other.getMaxSize()) {
            return false;
        }
        Tuple2<Double, Double> this$rope = this.getRope();
        Tuple2<Double, Double> other$rope = other.getRope();
        if (this$rope == null ? other$rope != null : !this$rope.equals(other$rope)) {
            return false;
        }
        if (this.getCooldownInterval() != other.getCooldownInterval()) {
            return false;
        }
        TimeUnit this$cooldownUnits = this.getCooldownUnits();
        TimeUnit other$cooldownUnits = other.getCooldownUnits();
        return !(this$cooldownUnits == null ? other$cooldownUnits != null : !((Object)((Object)this$cooldownUnits)).equals((Object)other$cooldownUnits));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Clutch.Metric $metric = this.getMetric();
        result = result * 59 + ($metric == null ? 43 : ((Object)((Object)$metric)).hashCode());
        long $setPoint = Double.doubleToLongBits(this.getSetPoint());
        result = result * 59 + (int)($setPoint >>> 32 ^ $setPoint);
        long $kp = Double.doubleToLongBits(this.getKp());
        result = result * 59 + (int)($kp >>> 32 ^ $kp);
        long $ki = Double.doubleToLongBits(this.getKi());
        result = result * 59 + (int)($ki >>> 32 ^ $ki);
        long $kd = Double.doubleToLongBits(this.getKd());
        result = result * 59 + (int)($kd >>> 32 ^ $kd);
        result = result * 59 + this.getMinSize();
        result = result * 59 + this.getMaxSize();
        Tuple2<Double, Double> $rope = this.getRope();
        result = result * 59 + ($rope == null ? 43 : $rope.hashCode());
        long $cooldownInterval = this.getCooldownInterval();
        result = result * 59 + (int)($cooldownInterval >>> 32 ^ $cooldownInterval);
        TimeUnit $cooldownUnits = this.getCooldownUnits();
        result = result * 59 + ($cooldownUnits == null ? 43 : ((Object)((Object)$cooldownUnits)).hashCode());
        return result;
    }

    public String toString() {
        return "ClutchConfiguration(metric=" + (Object)((Object)this.getMetric()) + ", setPoint=" + this.getSetPoint() + ", kp=" + this.getKp() + ", ki=" + this.getKi() + ", kd=" + this.getKd() + ", minSize=" + this.getMinSize() + ", maxSize=" + this.getMaxSize() + ", rope=" + this.getRope() + ", cooldownInterval=" + this.getCooldownInterval() + ", cooldownUnits=" + (Object)((Object)this.getCooldownUnits()) + ")";
    }

    public static class ClutchConfigurationBuilder {
        private Clutch.Metric metric;
        private double setPoint;
        private double kp;
        private double ki;
        private double kd;
        private int minSize;
        private int maxSize;
        private Tuple2<Double, Double> rope;
        private long cooldownInterval;
        private TimeUnit cooldownUnits;

        ClutchConfigurationBuilder() {
        }

        public ClutchConfigurationBuilder metric(Clutch.Metric metric) {
            this.metric = metric;
            return this;
        }

        public ClutchConfigurationBuilder setPoint(double setPoint) {
            this.setPoint = setPoint;
            return this;
        }

        public ClutchConfigurationBuilder kp(double kp) {
            this.kp = kp;
            return this;
        }

        public ClutchConfigurationBuilder ki(double ki) {
            this.ki = ki;
            return this;
        }

        public ClutchConfigurationBuilder kd(double kd) {
            this.kd = kd;
            return this;
        }

        public ClutchConfigurationBuilder minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public ClutchConfigurationBuilder maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public ClutchConfigurationBuilder rope(Tuple2<Double, Double> rope) {
            this.rope = rope;
            return this;
        }

        public ClutchConfigurationBuilder cooldownInterval(long cooldownInterval) {
            this.cooldownInterval = cooldownInterval;
            return this;
        }

        public ClutchConfigurationBuilder cooldownUnits(TimeUnit cooldownUnits) {
            this.cooldownUnits = cooldownUnits;
            return this;
        }

        public ClutchConfiguration build() {
            return new ClutchConfiguration(this.metric, this.setPoint, this.kp, this.ki, this.kd, this.minSize, this.maxSize, this.rope, this.cooldownInterval, this.cooldownUnits);
        }

        public String toString() {
            return "ClutchConfiguration.ClutchConfigurationBuilder(metric=" + (Object)((Object)this.metric) + ", setPoint=" + this.setPoint + ", kp=" + this.kp + ", ki=" + this.ki + ", kd=" + this.kd + ", minSize=" + this.minSize + ", maxSize=" + this.maxSize + ", rope=" + this.rope + ", cooldownInterval=" + this.cooldownInterval + ", cooldownUnits=" + (Object)((Object)this.cooldownUnits) + ")";
        }
    }
}

