/*
 * Copyright 2020 Netflix, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.netflix.control.clutch;

import io.vavr.Function3;

/**
 * A function for computing the new scale based on the current scale and the PID controller output.
 * Arguments:
 * 1.) the clutch configuration for the current control loop
 * 2.) the current scale
 * 3.) the delta computed by the PID controller
 * Return:
 * the new scale, which will be acted on by the actuator
 */
@FunctionalInterface
public interface IScaleComputer extends Function3<ClutchConfiguration, Long, Double, Double> {
}
