/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.controllers;

import com.netflix.control.IController;

public class Integrator
extends IController {
    private double sum = 0.0;
    private double min = Double.NEGATIVE_INFINITY;
    private double max = Double.POSITIVE_INFINITY;
    private double decayFactor = 1.0;

    public Integrator() {
    }

    public Integrator(double init) {
        this.sum = init;
    }

    public Integrator(double init, double min, double max) {
        this(init, min, max, 1.0);
    }

    public Integrator(double init, double min, double max, double decayFactor) {
        this.sum = init;
        this.min = min;
        this.max = max;
        this.decayFactor = decayFactor;
    }

    public void setSum(double val) {
        this.sum = val;
    }

    @Override
    protected Double processStep(Double input) {
        double newSum = this.sum + input;
        newSum = newSum > this.max ? this.max : newSum;
        newSum = newSum < this.min ? this.min : newSum;
        this.sum = this.decayFactor * newSum;
        return newSum;
    }
}

