/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.clutch;

import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.control.IActuator;
import com.netflix.control.clutch.Clutch;
import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.Event;
import com.netflix.control.controllers.ErrorComputer;
import com.netflix.control.controllers.Integrator;
import com.netflix.control.controllers.PIDController;
import io.vavr.Tuple;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ExperimentalControlLoop
implements Observable.Transformer<Event, Double> {
    private static final Logger log = LoggerFactory.getLogger(ExperimentalControlLoop.class);
    private final ClutchConfiguration config;
    private final IActuator actuator;
    private final Double initialSize;
    private final AtomicDouble dampener;
    private final long cooldownMillis;
    private final AtomicLong cooldownTimestamp;
    private final AtomicLong currentScale;
    private final AtomicDouble lastLag;
    private final Observable<Long> timer;
    private final Observable<Integer> size;

    public ExperimentalControlLoop(ClutchConfiguration config, IActuator actuator, Double initialSize, Observable<Long> timer, Observable<Integer> size) {
        this(config, actuator, initialSize, new AtomicDouble(1.0), timer, size);
    }

    public ExperimentalControlLoop(ClutchConfiguration config, IActuator actuator, Double initialSize, AtomicDouble dampener, Observable<Long> timer, Observable<Integer> size) {
        this.config = config;
        this.actuator = actuator;
        this.initialSize = initialSize;
        this.dampener = dampener;
        this.cooldownMillis = config.getCooldownUnits().toMillis(config.cooldownInterval);
        this.cooldownTimestamp = new AtomicLong(System.currentTimeMillis() + this.cooldownMillis);
        this.currentScale = new AtomicLong(Math.round(initialSize));
        this.lastLag = new AtomicDouble(0.0);
        this.timer = timer;
        this.size = size;
    }

    public Observable<Double> call(Observable<Event> events) {
        events = events.share();
        Observable lag = Observable.just((Object)new Event(Clutch.Metric.LAG, 0.0)).mergeWith(events.filter(event -> event.getMetric() == Clutch.Metric.LAG));
        Observable drops = Observable.just((Object)new Event(Clutch.Metric.DROPS, 0.0)).mergeWith(events.filter(event -> event.getMetric() == Clutch.Metric.DROPS));
        Observable rps = events.filter(event -> event.getMetric() == Clutch.Metric.RPS);
        Integrator integrator = new Integrator(this.initialSize, this.config.minSize, this.config.maxSize, this.config.integralDecay);
        this.size.takeUntil(this.timer).doOnNext(this.currentScale::set).doOnNext(integrator::setSum).doOnNext(__ -> this.cooldownTimestamp.set(System.currentTimeMillis())).doOnNext(n -> log.info("Clutch received new scheduling update with {} workers.", n)).subscribe();
        return rps.withLatestFrom(lag, drops, Tuple::of).doOnNext(triple -> log.debug("Clutch received RPS: {}, Lag: {} (d {}), Drops: {}", new Object[]{((Event)triple._1).value, ((Event)triple._2).value, ((Event)triple._2).value - this.lastLag.get(), ((Event)triple._3).value})).map(triple -> {
            double lagDerivative = ((Event)triple._2).value - this.lastLag.get();
            this.lastLag.set(((Event)triple._2).value);
            return ((Event)triple._1).value + lagDerivative + ((Event)triple._3).value;
        }).lift((Observable.Operator)new ErrorComputer(this.config.setPoint, true, (Double)this.config.rope._1, (Double)this.config.rope._2)).lift((Observable.Operator)new PIDController(this.config.kp, this.config.ki, this.config.kd, 1.0, new AtomicDouble(1.0), this.config.integralDecay)).lift((Observable.Operator)integrator).filter(__ -> this.cooldownMillis == 0L || this.cooldownTimestamp.get() <= System.currentTimeMillis() - this.cooldownMillis).filter(scale -> this.currentScale.get() != Math.round(Math.ceil(scale))).lift((Observable.Operator)this.actuator).doOnNext(scale -> this.currentScale.set(Math.round(Math.ceil(scale)))).doOnNext(__ -> this.cooldownTimestamp.set(System.currentTimeMillis()));
    }
}

