/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.clutch;

import com.netflix.control.clutch.Clutch;
import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.Event;
import com.netflix.control.clutch.metrics.IClutchMetricsRegistry;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.vavr.Function1;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;

public class ExperimentalClutchConfigurator
implements Observable.Transformer<Event, ClutchConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ExperimentalClutchConfigurator.class);
    private static int DEFAULT_K = 1024;
    private IClutchMetricsRegistry metricsRegistry;
    private final Observable<Long> timer;
    private final long initialConfigMilis;
    private final Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator;
    private static ConcurrentHashMap<Clutch.Metric, UpdateDoublesSketch> sketches = new ConcurrentHashMap();

    public ExperimentalClutchConfigurator(IClutchMetricsRegistry metricsRegistry, Observable<Long> timer, long initialConfigMillis, Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator) {
        this.metricsRegistry = metricsRegistry;
        this.timer = timer;
        this.initialConfigMilis = initialConfigMillis;
        this.configurator = configurator;
    }

    private ClutchConfiguration getConfig() {
        return (ClutchConfiguration)this.configurator.apply(sketches);
    }

    public Observable<ClutchConfiguration> call(Observable<Event> eventObservable) {
        Observable configs = this.timer.map(__ -> this.getConfig()).doOnNext(config -> System.out.println("New Config: " + config.toString()));
        Observable initialConfig = Observable.interval((long)this.initialConfigMilis, (TimeUnit)TimeUnit.MILLISECONDS).take(1).map(__ -> this.getConfig()).doOnNext(config -> System.out.println("Initial Config: " + config.toString()));
        eventObservable.filter(event -> event != null && event.metric != null).map(event -> {
            UpdateDoublesSketch sketch = sketches.computeIfAbsent(event.metric, metric -> UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
            sketch.update(event.value);
            return null;
        }).subscribe();
        return initialConfig.concatWith(configs).doOnNext(__ -> log.info("RPS Sketch State: {}", (Object)sketches.get((Object)Clutch.Metric.RPS))).doOnNext(__ -> ExperimentalClutchConfigurator.logSketchSummary((DoublesSketch)sketches.get((Object)Clutch.Metric.RPS))).doOnNext(config -> log.info("Clutch switched to config: {}", config));
    }

    private static void logSketchSummary(DoublesSketch sketch) {
        double[] quantiles = sketch.getQuantiles(new double[]{0.0, 0.25, 0.5, 0.75, 0.99, 1.0});
        log.info("RPS Sketch Quantiles -- Min: {}, 25th: {}, 50th: {}, 75th: {}, 99th: {}, Max: {}", new Object[]{quantiles[0], quantiles[1], quantiles[2], quantiles[3], quantiles[4], quantiles[5]});
    }

    static {
        sketches.put(Clutch.Metric.CPU, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.MEMORY, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.NETWORK, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.LAG, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.DROPS, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.UserDefined, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.RPS, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
    }
}

