/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.clutch;

import com.netflix.control.IActuator;
import com.netflix.control.clutch.Clutch;
import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.Event;
import com.netflix.control.clutch.ExperimentalClutchConfigurator;
import com.netflix.control.clutch.ExperimentalControlLoop;
import com.netflix.control.clutch.metrics.IClutchMetricsRegistry;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.vavr.Function1;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import rx.Observable;

public class ClutchExperimental
implements Observable.Transformer<Event, Object> {
    private final IActuator actuator;
    private final Integer initialSize;
    private final Integer minSize;
    private final Integer maxSize;
    private final Observable<Long> timer;
    private final Observable<Integer> size;
    private final long initialConfigMillis;
    private final Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator;

    public ClutchExperimental(IActuator actuator, Integer initialSize, Integer minSize, Integer maxSize, Observable<Integer> size, Observable<Long> timer, long initialConfigMillis, Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration> configurator) {
        this.actuator = actuator;
        this.initialSize = initialSize;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.size = size;
        this.timer = timer;
        this.initialConfigMillis = initialConfigMillis;
        this.configurator = configurator;
    }

    public ClutchExperimental(IActuator actuator, Integer initialSize, Integer minSize, Integer maxSize, Observable<Integer> size, Observable<Long> timer, long initialConfigMillis, long coolDownSeconds) {
        this(actuator, initialSize, minSize, maxSize, size, timer, initialConfigMillis, (Function1<Map<Clutch.Metric, UpdateDoublesSketch>, ClutchConfiguration>)(Function1 & Serializable)sketches -> {
            double setPoint = 0.6 * ((UpdateDoublesSketch)sketches.get((Object)Clutch.Metric.RPS)).getQuantile(0.99);
            Tuple2 rope = Tuple.of((Object)(setPoint * 0.15), (Object)0.0);
            double kp = setPoint * 1.0E-9 / 5.0;
            double ki = 0.0;
            double kd = setPoint * 1.0E-9 / 4.0;
            return new ClutchConfiguration.ClutchConfigurationBuilder().metric(Clutch.Metric.RPS).setPoint(setPoint).kp(kp).ki(ki).kd(kd).minSize(minSize).maxSize(maxSize).rope((Tuple2<Double, Double>)rope).cooldownInterval(coolDownSeconds).cooldownUnits(TimeUnit.SECONDS).build();
        });
    }

    public Observable<Object> call(Observable<Event> eventObservable) {
        Observable events = eventObservable.share();
        return events.compose((Observable.Transformer)new ExperimentalClutchConfigurator(new IClutchMetricsRegistry(){}, this.timer, this.initialConfigMillis, this.configurator)).flatMap(config -> events.compose((Observable.Transformer)new ExperimentalControlLoop((ClutchConfiguration)config, this.actuator, this.initialSize.doubleValue(), this.timer, this.size)).takeUntil(this.timer));
    }
}

