/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.clutch;

import com.google.common.annotations.VisibleForTesting;
import com.netflix.control.clutch.Clutch;
import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.Event;
import com.netflix.control.clutch.metrics.IClutchMetricsRegistry;
import com.yahoo.sketches.quantiles.DoublesSketch;
import com.yahoo.sketches.quantiles.UpdateDoublesSketch;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.collection.HashSet;
import io.vavr.collection.Set;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.schedulers.Schedulers;

public class ClutchConfigurator
implements Observable.Transformer<Event, ClutchConfiguration> {
    private static final Logger log = LoggerFactory.getLogger(ClutchConfigurator.class);
    private static double DEFAULT_SETPOINT = 60.0;
    private static Tuple2<Double, Double> DEFAULT_ROPE = Tuple.of((Object)25.0, (Object)0.0);
    private static int DEFAULT_K = 1024;
    private static double DEFAULT_QUANTILE = 0.99;
    private IClutchMetricsRegistry metricsRegistry;
    private final Integer minSize;
    private final Integer maxSize;
    private final Observable<Long> timer;
    private Integer loggingIntervalMins = 60;
    private static Set<Clutch.Metric> resourceMetrics = HashSet.of((Object[])new Clutch.Metric[]{Clutch.Metric.CPU, Clutch.Metric.MEMORY, Clutch.Metric.NETWORK, Clutch.Metric.UserDefined});
    private static ConcurrentHashMap<Clutch.Metric, UpdateDoublesSketch> sketches = new ConcurrentHashMap();

    public ClutchConfigurator(IClutchMetricsRegistry metricsRegistry, Integer minSize, Integer maxSize, Observable<Long> timer) {
        this.metricsRegistry = metricsRegistry;
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.timer = timer;
    }

    public ClutchConfigurator(IClutchMetricsRegistry metricsRegistry, Integer minSize, Integer maxSize, Observable<Long> timer, Integer loggingIntervalMins) {
        this(metricsRegistry, minSize, maxSize, timer);
        this.loggingIntervalMins = loggingIntervalMins;
    }

    private static Clutch.Metric determineDominantMetric(List<Map.Entry<Clutch.Metric, UpdateDoublesSketch>> metrics) {
        if (metrics.stream().filter(metric -> metric.getKey() == Clutch.Metric.UserDefined).count() > 0L) {
            return Clutch.Metric.UserDefined;
        }
        Clutch.Metric metric2 = metrics.stream().max(Comparator.comparingDouble(a -> ((UpdateDoublesSketch)a.getValue()).getQuantile(DEFAULT_QUANTILE))).map(Map.Entry::getKey).get();
        log.info("Determined dominant resource: {}", (Object)metric2.toString());
        return metric2;
    }

    private static double determineSetpoint(DoublesSketch metric) {
        double quantile = metric.getQuantile(DEFAULT_QUANTILE);
        double setPoint = quantile * (DEFAULT_SETPOINT / 100.0);
        setPoint = setPoint == Double.NaN ? DEFAULT_SETPOINT : setPoint;
        double bounded = ClutchConfigurator.bound(1.0, DEFAULT_SETPOINT, setPoint);
        log.info("Determined quantile {} and setPoint of {} bounding to {}.", new Object[]{quantile, setPoint, bounded});
        return bounded;
    }

    protected ClutchConfiguration getConfig() {
        Clutch.Metric dominantResource = ClutchConfigurator.determineDominantMetric(sketches.entrySet().stream().filter(x -> ClutchConfigurator.isResourceMetric((Clutch.Metric)((Object)((Object)x.getKey())))).filter(x -> ((UpdateDoublesSketch)x.getValue()).getN() > 0L).collect(Collectors.toList()));
        double setPoint = ClutchConfigurator.determineSetpoint((DoublesSketch)sketches.get((Object)dominantResource));
        return new ClutchConfiguration.ClutchConfigurationBuilder().metric(dominantResource).setPoint(setPoint).kp(0.01).ki(0.01).kd(0.01).minSize(this.minSize).maxSize(this.maxSize).rope(DEFAULT_ROPE).cooldownInterval(5L).cooldownUnits(TimeUnit.MINUTES).build();
    }

    private ClutchConfiguration getPinHighConfig() {
        return new ClutchConfiguration.ClutchConfigurationBuilder().metric(Clutch.Metric.CPU).setPoint(DEFAULT_SETPOINT).kp(0.01).ki(0.01).kd(0.01).minSize(this.maxSize).maxSize(this.maxSize).rope(DEFAULT_ROPE).cooldownInterval(5L).cooldownUnits(TimeUnit.MINUTES).build();
    }

    protected UpdateDoublesSketch getSketch(Clutch.Metric metric) {
        return sketches.get((Object)metric);
    }

    public Observable<ClutchConfiguration> call(Observable<Event> eventObservable) {
        eventObservable = eventObservable.share();
        Observable logs = Observable.interval((long)this.loggingIntervalMins.intValue(), (TimeUnit)TimeUnit.MINUTES).observeOn(Schedulers.newThread()).map(__ -> {
            this.logSketchSummary("CPU", sketches.get((Object)Clutch.Metric.CPU));
            this.logSketchSummary("MEMORY", sketches.get((Object)Clutch.Metric.MEMORY));
            this.logSketchSummary("NETWORK", sketches.get((Object)Clutch.Metric.NETWORK));
            this.logSketchSummary("UserDefined", sketches.get((Object)Clutch.Metric.UserDefined));
            return null;
        });
        Observable configs = this.timer.map(__ -> this.getConfig());
        return eventObservable.filter(event -> event != null && event.metric != null).map(event -> {
            UpdateDoublesSketch sketch = sketches.computeIfAbsent(event.metric, metric -> UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
            sketch.update(event.value);
            return null;
        }).mergeWith(logs).filter(Objects::nonNull).cast(ClutchConfiguration.class).mergeWith(Observable.just((Object)this.getPinHighConfig())).mergeWith(configs).doOnNext(config -> log.info(config.toString()));
    }

    private void logSketchSummary(String name, UpdateDoublesSketch sketch) {
        log.info("{} sketch ({}) min: {}, max: {}, median: {}, 99th: {}", new Object[]{name, sketch.getN(), sketch.getMinValue(), sketch.getMaxValue(), sketch.getQuantile(0.5), sketch.getQuantile(0.99)});
    }

    private static boolean isResourceMetric(Clutch.Metric metric) {
        return resourceMetrics.contains((Object)metric);
    }

    @VisibleForTesting
    static double bound(double min, double max, double value) {
        return value < min ? min : (value > max ? max : value);
    }

    static {
        sketches.put(Clutch.Metric.CPU, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.MEMORY, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.NETWORK, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.LAG, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.DROPS, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
        sketches.put(Clutch.Metric.UserDefined, UpdateDoublesSketch.builder().setK(DEFAULT_K).build());
    }
}

