/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.control.clutch;

import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.control.IActuator;
import com.netflix.control.clutch.ClutchConfiguration;
import com.netflix.control.clutch.ClutchConfigurator;
import com.netflix.control.clutch.Event;
import com.netflix.control.clutch.OscillationDetector;
import com.netflix.control.clutch.metrics.IClutchMetricsRegistry;
import com.netflix.control.controllers.ControlLoop;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;

public class Clutch
implements Observable.Transformer<Event, Object> {
    private final IActuator actuator;
    private final AtomicLong initialSize;
    private final Integer minSize;
    private final Integer maxSize;
    private final AtomicDouble dampener;
    private Integer loggingIntervalMins = 60;
    private final Observable<Long> timer = Observable.interval((long)1L, (TimeUnit)TimeUnit.DAYS).share();

    public Clutch(IActuator actuator, Integer initialSize, Integer minSize, Integer maxSize) {
        this.actuator = actuator;
        this.initialSize = new AtomicLong(initialSize.intValue());
        this.minSize = minSize;
        this.maxSize = maxSize;
        this.dampener = new AtomicDouble(1.0);
    }

    public Clutch(IActuator actuator, Integer initialSize, Integer minSize, Integer maxSize, Integer loggingIntervalMins) {
        this(actuator, initialSize, minSize, maxSize);
        this.loggingIntervalMins = loggingIntervalMins;
    }

    public Observable<Object> call(Observable<Event> eventObservable) {
        Observable events = eventObservable.share();
        return events.compose((Observable.Transformer)new ClutchConfigurator(new IClutchMetricsRegistry(){}, this.minSize, this.maxSize, this.timer, this.loggingIntervalMins)).flatMap(config -> events.compose((Observable.Transformer)new ControlLoop((ClutchConfiguration)config, this.actuator, this.initialSize, this.dampener)).takeUntil(this.timer)).lift((Observable.Operator)new OscillationDetector(60, x -> this.dampener.set(Math.pow(x, 3.0))));
    }

    public static enum Metric {
        CPU,
        MEMORY,
        NETWORK,
        LAG,
        DROPS,
        RESISTANCE,
        UserDefined,
        RPS,
        SOURCEJOB_DROP;

    }
}

