/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.common.codec.Codecs;
import io.mantisrx.runtime.NettyCodec;
import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.computation.ToScalarComputation;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.reactivex.netty.codec.Codec;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class KeyToScalar<K, T, R>
extends StageConfig<T, R> {
    private final ToScalarComputation<K, T, R> computation;
    private final long keyExpireTimeSeconds;

    KeyToScalar(ToScalarComputation<K, T, R> computation, Config<K, T, R> config, Codec<T> inputCodec) {
        this(computation, config, NettyCodec.fromNetty(inputCodec));
    }

    KeyToScalar(ToScalarComputation<K, T, R> computation, Config<K, T, R> config, io.mantisrx.common.codec.Codec<T> inputCodec) {
        this(computation, config, Codecs.string(), inputCodec);
    }

    KeyToScalar(ToScalarComputation<K, T, R> computation, Config<K, T, R> config, io.mantisrx.common.codec.Codec<K> inputKeyCodec, io.mantisrx.common.codec.Codec<T> inputCodec) {
        super(((Config)config).description, inputKeyCodec, inputCodec, ((Config)config).codec, ((Config)config).inputStrategy, ((Config)config).parameters);
        this.computation = computation;
        this.keyExpireTimeSeconds = ((Config)config).keyExpireTimeSeconds;
    }

    public ToScalarComputation<K, T, R> getComputation() {
        return this.computation;
    }

    public long getKeyExpireTimeSeconds() {
        return this.keyExpireTimeSeconds;
    }

    public static class Config<K, T, R> {
        private io.mantisrx.common.codec.Codec<R> codec;
        private String description;
        private long keyExpireTimeSeconds = TimeUnit.HOURS.toSeconds(1L);
        private final StageConfig.INPUT_STRATEGY inputStrategy = StageConfig.INPUT_STRATEGY.SERIAL;
        private List<ParameterDefinition<?>> parameters = Collections.emptyList();

        public Config<K, T, R> codec(Codec<R> codec) {
            this.codec = NettyCodec.fromNetty(codec);
            return this;
        }

        public Config<K, T, R> codec(io.mantisrx.common.codec.Codec<R> codec) {
            this.codec = codec;
            return this;
        }

        public Config<K, T, R> keyExpireTimeSeconds(long seconds) {
            this.keyExpireTimeSeconds = seconds;
            return this;
        }

        public Config<K, T, R> description(String description) {
            this.description = description;
            return this;
        }

        public io.mantisrx.common.codec.Codec<R> getCodec() {
            return this.codec;
        }

        public String getDescription() {
            return this.description;
        }

        public long getKeyExpireTimeSeconds() {
            return this.keyExpireTimeSeconds;
        }

        public StageConfig.INPUT_STRATEGY getInputStrategy() {
            return this.inputStrategy;
        }

        public Config<K, T, R> withParameters(List<ParameterDefinition<?>> params) {
            this.parameters = params;
            return this;
        }
    }
}

