/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.core;

import java.time.Duration;

public class WindowSpec {
    private final WindowType type;
    private int numElements;
    private int elementOffset;
    private Duration windowLength;
    private Duration windowOffset;

    WindowSpec(WindowType type, Duration windowLength, Duration windowOffset) {
        this.type = type;
        this.windowLength = windowLength;
        this.windowOffset = windowOffset;
    }

    WindowSpec(WindowType type, int numElements, int elementOffset) {
        this.type = type;
        this.numElements = numElements;
        this.elementOffset = elementOffset;
    }

    public static WindowSpec timed(Duration windowLength) {
        return new WindowSpec(WindowType.TUMBLING, windowLength, windowLength);
    }

    public static WindowSpec timed(Duration windowLength, Duration windowOffset) {
        return new WindowSpec(WindowType.SLIDING, windowLength, windowOffset);
    }

    public static WindowSpec count(int numElements) {
        return new WindowSpec(WindowType.ELEMENT, numElements, numElements);
    }

    public static WindowSpec count(int numElements, int elementOffset) {
        return new WindowSpec(WindowType.ELEMENT_SLIDING, numElements, elementOffset);
    }

    public WindowType getType() {
        return this.type;
    }

    public int getNumElements() {
        return this.numElements;
    }

    public int getElementOffset() {
        return this.elementOffset;
    }

    public Duration getWindowLength() {
        return this.windowLength;
    }

    public Duration getWindowOffset() {
        return this.windowOffset;
    }

    public static enum WindowType {
        TUMBLING,
        SLIDING,
        ELEMENT,
        ELEMENT_SLIDING;

    }
}

