/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter;

import io.mantisrx.runtime.parameter.Parameter;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import io.mantisrx.runtime.parameter.Parameters;
import io.mantisrx.runtime.parameter.type.BooleanParameter;
import io.mantisrx.runtime.parameter.type.IntParameter;
import io.mantisrx.runtime.parameter.type.StringParameter;
import io.mantisrx.runtime.parameter.validator.Validation;
import io.mantisrx.runtime.parameter.validator.Validators;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.functions.Func1;

public class ParameterUtils {
    private static final Logger log = LoggerFactory.getLogger(ParameterUtils.class);
    static final Map<String, ParameterDefinition<?>> systemParams = new ConcurrentHashMap();

    private ParameterUtils() {
    }

    public static Parameters createContextParameters(Map<String, ParameterDefinition<?>> parameterDefinitions, Parameter ... parameters) {
        HashMap<String, Parameter> indexed = new HashMap<String, Parameter>();
        parameterDefinitions.putAll(systemParams);
        for (Parameter parameter : parameters) {
            indexed.put(parameter.getName(), parameter);
        }
        return new Parameters(ParameterUtils.checkThenCreateState(parameterDefinitions, indexed), ParameterUtils.getRequiredParameters(parameterDefinitions), ParameterUtils.getParameterDefinitions(parameterDefinitions));
    }

    public static Parameters createContextParameters(Map<String, ParameterDefinition<?>> parameterDefinitions, List<Parameter> parameters) {
        parameterDefinitions.putAll(systemParams);
        Parameter[] array = parameters.toArray(new Parameter[parameters.size()]);
        return ParameterUtils.createContextParameters(parameterDefinitions, array);
    }

    private static void validationCheck(Func1 validator, Object value, String name) throws IllegalArgumentException {
        Validation validatorOutcome;
        if (validator == null) {
            throw new IllegalArgumentException("Validator for parameter definition: " + name + " is null");
        }
        try {
            validatorOutcome = (Validation)validator.call(value);
        }
        catch (Throwable t) {
            throw new IllegalArgumentException("Parameter: " + name + " with value: " + value + " failed validator: " + t.getMessage(), t);
        }
        if (validatorOutcome.isFailedValidation()) {
            throw new IllegalArgumentException("Parameter: " + name + " with value: " + value + " failed validator: " + validatorOutcome.getFailedValidationReason());
        }
    }

    public static <T> Map<String, Object> checkThenCreateState(Map<String, ParameterDefinition<?>> parameterDefinitions, Map<String, Parameter> parameters) throws IllegalArgumentException {
        HashMap<String, Object> parameterState = new HashMap<String, Object>();
        for (ParameterDefinition<?> definition : parameterDefinitions.values()) {
            if (definition.isRequired() && !parameters.containsKey(definition.getName()) && definition.getDefaultValue() == null) {
                throw new IllegalArgumentException("Missing required parameter: " + definition.getName() + ", check job parameter definitions.");
            }
            if (definition.getDefaultValue() == null) continue;
            ParameterUtils.validationCheck(definition.getValidator().getValidator(), definition.getDefaultValue(), "[default value] " + definition.getName());
            parameterState.put(definition.getName(), definition.getDefaultValue());
        }
        for (Parameter parameter : parameters.values()) {
            String name = parameter.getName();
            ParameterDefinition<?> definition = parameterDefinitions.get(name);
            if (definition == null) {
                if (name.equals("MANTIS_WORKER_JVM_OPTS") || name.startsWith("MANTIS_WORKER_JVM_OPTS_STAGE")) {
                    log.warn("Ignoring invalid parameter definitions with name: {}, will skip parameter", (Object)name);
                    continue;
                }
                if (name.startsWith("mantis.") || name.startsWith("MANTIS")) {
                    log.info("mantis runtime parameter {} used, looking up definition >>>", (Object)name);
                    definition = systemParams.get(name);
                } else {
                    log.warn("No parameter definition for parameter with name: {}, will skip parameter", (Object)name);
                    continue;
                }
            }
            Func1<?, Validation> validator = definition.getValidator().getValidator();
            Object value = definition.getDecoder().decode(parameter.getValue());
            ParameterUtils.validationCheck(validator, value, name);
            parameterState.put(name, value);
        }
        return parameterState;
    }

    public static Set<String> getRequiredParameters(Map<String, ParameterDefinition<?>> parameterDefinitions) {
        HashSet<String> requiredParameters = new HashSet<String>();
        for (ParameterDefinition<?> definition : parameterDefinitions.values()) {
            if (!definition.isRequired()) continue;
            requiredParameters.add(definition.getName());
        }
        return requiredParameters;
    }

    public static Set<String> getParameterDefinitions(Map<String, ParameterDefinition<?>> parameterDefinitions) {
        HashSet<String> parameters = new HashSet<String>();
        for (ParameterDefinition<?> definition : parameterDefinitions.values()) {
            parameters.add(definition.getName());
        }
        return parameters;
    }

    public static Map<String, ParameterDefinition<?>> getSystemParameters() {
        return Collections.unmodifiableMap(systemParams);
    }

    static {
        ParameterDefinition<Integer> keyBuffer = new IntParameter().name("mantis.w2w.toKeyBuffer").validator(Validators.range(1, 100000)).defaultValue(50000).description("per connection buffer from Scalar To Key stage").build();
        systemParams.put(keyBuffer.getName(), keyBuffer);
        ParameterDefinition<Boolean> useSPSC4sse = new BooleanParameter().name("mantis.sse.spsc").description("Whether to use spsc or blocking queue for SSE").defaultValue(false).build();
        systemParams.put(useSPSC4sse.getName(), useSPSC4sse);
        ParameterDefinition<Boolean> useSPSC4w2w = new BooleanParameter().name("mantis.w2w.spsc").description("Whether to use spsc or blocking queue").defaultValue(false).build();
        systemParams.put(useSPSC4w2w.getName(), useSPSC4w2w);
        ParameterDefinition<Boolean> singleNettyThread = new BooleanParameter().name("mantis.netty.useSingleThread").description("use single netty thread").defaultValue(false).build();
        systemParams.put(singleNettyThread.getName(), singleNettyThread);
        ParameterDefinition<Integer> w2wtoKeyMaxChunkSize = new IntParameter().name("mantis.w2w.toKeyMaxChunkSize").validator(Validators.range(1, 100000)).defaultValue(1000).description("batch size for bytes drained from Scalar To Key stage").build();
        systemParams.put(w2wtoKeyMaxChunkSize.getName(), w2wtoKeyMaxChunkSize);
        ParameterDefinition<Integer> w2wtoKeyThreads = new IntParameter().name("mantis.w2w.toKeyThreads").validator(Validators.range(1, 8)).description("number of drainer threads on the ScalarToKey stage").defaultValue(1).build();
        systemParams.put(w2wtoKeyThreads.getName(), w2wtoKeyThreads);
        ParameterDefinition<Integer> sseBuffer = new IntParameter().name("mantis.sse.bufferCapacity").validator(Validators.range(1, 100000)).description("buffer on SSE per connection").defaultValue(25000).build();
        systemParams.put(sseBuffer.getName(), sseBuffer);
        ParameterDefinition<Integer> sseChunkSize = new IntParameter().name("mantis.sse.maxChunkSize").validator(Validators.range(1, 100000)).description("SSE chunk size").defaultValue(1000).build();
        systemParams.put(sseChunkSize.getName(), sseChunkSize);
        ParameterDefinition<Integer> sseMaxReadTime = new IntParameter().name("mantis.sse.maxReadTimeMSec").validator(Validators.range(1, 100000)).description("interval at which buffer is drained to write to SSE").defaultValue(250).build();
        systemParams.put(sseMaxReadTime.getName(), sseMaxReadTime);
        ParameterDefinition<Integer> sse_numConsumerThreads = new IntParameter().name("mantis.sse.numConsumerThreads").validator(Validators.range(1, 8)).description("number of consumer threads draining the queue to write to SSE").defaultValue(1).build();
        systemParams.put(sse_numConsumerThreads.getName(), sse_numConsumerThreads);
        ParameterDefinition<Integer> maxNotWritableTimeSec = new IntParameter().name("mantis.sse.maxNotWritableTimeSec").validator(Validators.range(-1, 100000)).description("maximum time the SSE connection can remain not writable before we proactively terminated it on server side. <= 0 means unlimited.").defaultValue(-1).build();
        systemParams.put(maxNotWritableTimeSec.getName(), maxNotWritableTimeSec);
        ParameterDefinition<String> jobMasterAutoScaleMetric = new StringParameter().name("mantis.jobmaster.autoscale.metric").validator(Validators.alwaysPass()).description("Custom autoscale metric for Job Master to use with UserDefined Scaling Strategy. Format: <metricGroup>::<metricName>::<algo> where metricGroup and metricName should exactly match the metric published via Mantis MetricsRegistry and algo = MAX/AVERAGE").defaultValue("").build();
        systemParams.put(jobMasterAutoScaleMetric.getName(), jobMasterAutoScaleMetric);
        ParameterDefinition<String> jobMasterAutoScaleConfig = new StringParameter().name("mantis.jobmaster.clutch.config").validator(Validators.alwaysPass()).description("Configuration for the clutch autoscaler.").defaultValue("").build();
        systemParams.put(jobMasterAutoScaleConfig.getName(), jobMasterAutoScaleConfig);
        ParameterDefinition<Boolean> clutchExperimentalEnabled = new BooleanParameter().name("mantis.jobmaster.clutch.experimental.enabled").validator(Validators.alwaysPass()).description("Enables the experimental version of the Clutch autoscaler. Note this is different from the Clutch used in production today.").defaultValue(false).build();
        systemParams.put(clutchExperimentalEnabled.getName(), clutchExperimentalEnabled);
        ParameterDefinition<Integer> stageConcurrency = new IntParameter().name("mantis.stageConcurrency").validator(Validators.range(-1, 16)).defaultValue(-1).description("Number of cores to use for stage processing").build();
        systemParams.put(stageConcurrency.getName(), stageConcurrency);
        ParameterDefinition<Boolean> sseBinary = new BooleanParameter().name("mantis.EnableCompressedBinary").validator(Validators.alwaysPass()).defaultValue(false).description("Enables binary compression of SSE data").build();
        systemParams.put(sseBinary.getName(), sseBinary);
        ParameterDefinition<String> compressionDelimiter = new StringParameter().name("mantis.CompressionDelimiter").validator(Validators.alwaysPass()).defaultValue("$$$").description("Delimiter for separating SSE data before compression").build();
        systemParams.put(compressionDelimiter.getName(), compressionDelimiter);
        ParameterDefinition<Boolean> autoscaleSourceJobMetricEnabled = new BooleanParameter().name("mantis.jobmaster.autoscale.sourcejob.metric.enabled").validator(Validators.alwaysPass()).defaultValue(false).description("Enable source job drop metrics to be used for autoscaling the 1st stage").build();
        systemParams.put(autoscaleSourceJobMetricEnabled.getName(), autoscaleSourceJobMetricEnabled);
        ParameterDefinition<String> autoscaleSourceJobTarget = new StringParameter().name("mantis.jobmaster.autoscale.sourcejob.target").validator(Validators.alwaysPass()).defaultValue("{}").description("Json config to specify source job targets for autoscale metrics. This param is not needed if the 'target' param is already present. Example: {\"targets\": [{\"sourceJobName\":<jobName>, \"clientId\":<clientId>}]}").build();
        systemParams.put(autoscaleSourceJobTarget.getName(), autoscaleSourceJobTarget);
        ParameterDefinition<String> autoscaleSourceJobDropMetricPattern = new StringParameter().name("mantis.jobmaster.autoscale.sourcejob.dropMetricPatterns").validator(Validators.alwaysPass()).defaultValue("").description("Additional metrics pattern for source job drops. Comma separated list, supports dynamic client ID by using '_CLIENT_ID_' as a token. Each metric should be expressed in the same format as 'mantis.jobmaster.autoscale.metric'. Example: PushServerSse:clientId=_CLIENT_ID_:*::droppedCounter::MAX,ServerSentEventRequestHandler:clientId=_CLIENT_ID_:*::droppedCounter::MAX").build();
        systemParams.put(autoscaleSourceJobDropMetricPattern.getName(), autoscaleSourceJobDropMetricPattern);
        ParameterDefinition<Integer> workerHeartbeatInterval = new IntParameter().name("mantis.job.worker.heartbeat.interval.secs").validator(Validators.alwaysPass()).defaultValue(0).description("Configures heartbeat interval (in seconds) for job workers. This is useful to configure worker restart logic.").build();
        systemParams.put(workerHeartbeatInterval.getName(), workerHeartbeatInterval);
        ParameterDefinition<Integer> workerTimeout = new IntParameter().name("mantis.job.worker.timeout.secs").validator(Validators.alwaysPass()).defaultValue(0).description("Configures timeout interval (in seconds) for job workers. There is some grace period and retries built in to allow for network delays and/or miss a few worker heartbeats before being killed.").build();
        systemParams.put(workerTimeout.getName(), workerTimeout);
    }
}

