/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.parameter;

import io.mantisrx.runtime.parameter.ParameterDecoder;
import io.mantisrx.runtime.parameter.ParameterException;
import io.mantisrx.runtime.parameter.validator.Validator;

public class ParameterDefinition<T> {
    private final String name;
    private final String description;
    private final T defaultValue;
    private final String typeDescription;
    private final Validator<? super T> validator;
    private final boolean required;
    private final ParameterDecoder<T> decoder;

    ParameterDefinition(Builder<T> builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.validator = builder.validator;
        this.required = builder.required;
        this.typeDescription = builder.getTypeDescription();
        this.defaultValue = builder.defaultValue;
        this.decoder = builder.decoder();
    }

    public ParameterDecoder<T> getDecoder() {
        return this.decoder;
    }

    public String getTypeDescription() {
        return this.typeDescription;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Validator<? super T> getValidator() {
        return this.validator;
    }

    public boolean isRequired() {
        return this.required;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public String toString() {
        return "ParameterDefinition [name=" + this.name + ", description=" + this.description + ", validator=" + this.validator + ", required=" + this.required + "]";
    }

    public static abstract class Builder<T> {
        protected String name;
        protected String description;
        protected T defaultValue;
        protected Validator<? super T> validator;
        protected boolean required = false;

        public abstract ParameterDecoder<T> decoder();

        public abstract String getTypeDescription();

        @Deprecated
        public abstract Class<T> classType();

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> description(String description) {
            this.description = description;
            return this;
        }

        public Builder<T> validator(Validator<? super T> validator) {
            this.validator = validator;
            return this;
        }

        public Builder<T> required() {
            this.required = true;
            return this;
        }

        public ParameterDefinition<T> build() {
            if (this.validator == null) {
                throw new ParameterException("A validator must be specified for parameter: " + this.name);
            }
            return new ParameterDefinition(this);
        }
    }
}

