/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime.command;

import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.MantisJobProvider;
import io.mantisrx.runtime.command.Command;
import io.mantisrx.runtime.command.CommandException;
import io.mantisrx.runtime.command.ReadJobFromZipException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadJobFromZip
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(ReadJobFromZip.class);
    private final String jobZipFile;
    private final String artifactName;
    private final String version;
    private Job job;

    public ReadJobFromZip(String jobZipFile, String artifactName, String version) {
        this.jobZipFile = jobZipFile;
        this.artifactName = artifactName;
        this.version = version;
    }

    public Job getJob() {
        return this.job;
    }

    @Override
    public void execute() throws CommandException {
        try {
            ZipFile zipFile = new ZipFile(this.jobZipFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            String jobProviderFilename = "io.mantisrx.runtime.MantisJobProvider";
            boolean jobProviderFound = false;
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().matches("^.*" + jobProviderFilename + "$")) continue;
                jobProviderFound = true;
                InputStream mainClassInputStream = zipFile.getInputStream(zipEntry);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(mainClassInputStream));
                String jobProviderClassName = bufferedReader.readLine();
                logger.info("loading MantisJobProvider from " + jobProviderClassName);
                Class<?> clazz = Class.forName(jobProviderClassName);
                MantisJobProvider jobProvider = (MantisJobProvider)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.job = jobProvider.getJobInstance();
                break;
            }
            if (!jobProviderFound) {
                throw new ReadJobFromZipException("no entries in ZipFile matching jobProvider " + jobProviderFilename);
            }
            if (this.job == null) {
                throw new ReadJobFromZipException("failed to load job from classname in " + jobProviderFilename);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new ReadJobFromZipException(e);
        }
        catch (NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

