/*
 * Decompiled with CFR 0.152.
 */
package io.mantisrx.runtime;

import io.mantisrx.runtime.DefaultLifecycleFactory;
import io.mantisrx.runtime.Job;
import io.mantisrx.runtime.Metadata;
import io.mantisrx.runtime.SinkHolder;
import io.mantisrx.runtime.SourceHolder;
import io.mantisrx.runtime.StageConfig;
import io.mantisrx.runtime.Stages;
import io.mantisrx.runtime.lifecycle.Lifecycle;
import io.mantisrx.runtime.parameter.ParameterDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Config<T> {
    private Metadata metadata = new Metadata();
    private final SourceHolder<?> source;
    private final List<StageConfig<?, ?>> stages;
    private final SinkHolder<T> sink;
    private Lifecycle lifecycle = DefaultLifecycleFactory.getInstance();
    private final Map<String, ParameterDefinition<?>> parameterDefinitions = new HashMap();

    Config(Stages<?> stages, SinkHolder<T> observable) {
        this.source = stages.getSource();
        this.stages = stages.getStages();
        this.sink = observable;
        this.initParams();
    }

    private void putParameterOnce(ParameterDefinition<?> definition) {
        String name = definition.getName();
        if (this.parameterDefinitions.containsKey(name)) {
            throw new IllegalArgumentException("cannot have two parameters with same name " + name);
        }
        this.parameterDefinitions.put(name, definition);
    }

    private void initParams() {
        this.source.getSourceFunction().getParameters().forEach(this::putParameterOnce);
        for (StageConfig<?, ?> stage : this.stages) {
            stage.getParameters().forEach(this::putParameterOnce);
        }
        this.sink.getSinkAction().getParameters().forEach(this::putParameterOnce);
    }

    public Config<T> lifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
        return this;
    }

    public Config<T> metadata(Metadata metadata) {
        this.metadata = metadata;
        return this;
    }

    public Config<T> parameterDefinition(ParameterDefinition<?> definition) {
        this.parameterDefinitions.put(definition.getName(), definition);
        return this;
    }

    public Job<T> create() {
        return new Job<T>(this.source, this.stages, this.sink, this.lifecycle, this.metadata, this.parameterDefinitions);
    }
}

